/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.net.DatagramPacket;
import org.ice4j.socket.DTLSDatagramFilter;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.RtpChannel;

class RtpChannelDatagramFilter
implements DatagramPacketFilter {
    private static final Logger logger = Logger.getLogger(RtpChannelDatagramFilter.class);
    private boolean acceptNonRtp = false;
    private final RtpChannel channel;
    private boolean missingPtsWarningLogged = false;
    private final boolean rtcp;

    RtpChannelDatagramFilter(RtpChannel channel, boolean rtcp) {
        this(channel, rtcp, false);
    }

    RtpChannelDatagramFilter(RtpChannel channel, boolean rtcp, boolean acceptNonRtp) {
        this.channel = channel;
        this.rtcp = rtcp;
        this.acceptNonRtp = acceptNonRtp;
    }

    public boolean accept(DatagramPacket p) {
        int off;
        byte[] data;
        int len = p.getLength();
        if (len >= 4 && ((data = p.getData())[(off = p.getOffset()) + 0] & 0xC0) >> 6 == 2) {
            int pt = data[off + 1] & 0xFF;
            if (200 <= pt && pt <= 211) {
                return this.rtcp && this.acceptRTCP(data, off, len);
            }
            return !this.rtcp && this.acceptRTP(pt & 0x7F);
        }
        return this.acceptNonRtp && DTLSDatagramFilter.isDTLS((DatagramPacket)p);
    }

    private boolean acceptRTCP(byte[] data, int off, int len) {
        if (len >= 8) {
            int[] channelSSRCs;
            int packetSenderSSRC = RTPTranslatorImpl.readInt((byte[])data, (int)(off + 4));
            for (int channelSSRC : channelSSRCs = this.channel.getReceiveSSRCs()) {
                if (channelSSRC != packetSenderSSRC) continue;
                return true;
            }
        }
        return false;
    }

    private boolean acceptRTP(int pt) {
        int[] channelPTs = this.channel.getReceivePTs();
        if (channelPTs == null || channelPTs.length == 0) {
            if (this.channel.getChannelBundleId() == null) {
                return true;
            }
            if (!this.missingPtsWarningLogged) {
                this.missingPtsWarningLogged = true;
                logger.warn((Object)("No payload-types specified for channel " + this.channel.getID() + " while bundle is in use. Packets" + " are dropped."));
            }
            return false;
        }
        for (int channelPT : channelPTs) {
            if (channelPT != pt) continue;
            return true;
        }
        return false;
    }

    public void setAcceptNonRtp(boolean acceptNonRtp) {
        this.acceptNonRtp = acceptNonRtp;
    }
}

