/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.launchutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ScStdOut;
import net.java.sip.communicator.util.launchutils.AEGetURLEventHandler;
import net.java.sip.communicator.util.launchutils.ArgDelegationPeer;
import net.java.sip.communicator.util.launchutils.ArgDelegator;

public class LaunchArgHandler {
    private static final Logger logger = Logger.getLogger(LaunchArgHandler.class);
    private static final String PNAME_SC_HOME_DIR_LOCATION = "net.java.sip.communicator.SC_HOME_DIR_LOCATION";
    private static final String PNAME_SC_CACHE_DIR_LOCATION = "net.java.sip.communicator.SC_CACHE_DIR_LOCATION";
    private static final String PNAME_SC_LOG_DIR_LOCATION = "net.java.sip.communicator.SC_LOG_DIR_LOCATION";
    private static final String PNAME_SC_HOME_DIR_NAME = "net.java.sip.communicator.SC_HOME_DIR_NAME";
    public static final int ACTION_EXIT = 0;
    public static final int ACTION_CONTINUE = 1;
    public static final int ACTION_ERROR = 2;
    public static final int ACTION_CONTINUE_LOCK_DISABLED = 3;
    public static final int ERROR_CODE_UNKNOWN_ARG = 1;
    public static final int ERROR_CODE_ALREADY_STARTED = 2;
    public static final int ERROR_CODE_CREATE_DIR_FAILED = 3;
    private static final String PNAME_APPLICATION_NAME = "APPLICATION_NAME";
    private static final String PNAME_PACKAGE_NAME = "PACKAGE_NAME";
    private static final String PNAME_VERSION = "APPLICATION_VERSION";
    private static final String VERSION_PROPERTIES = "version.properties";
    private int errorCode = 0;
    private ArgDelegator argDelegator = new ArgDelegator();
    private static LaunchArgHandler argHandler = null;
    private Properties versionProperties = new Properties();

    private LaunchArgHandler() {
        String osName;
        InputStream versionPropertiesStream = this.getClass().getResourceAsStream(VERSION_PROPERTIES);
        boolean versionPropertiesAreLoaded = false;
        if (versionPropertiesStream != null) {
            try {
                try {
                    this.versionProperties.load(versionPropertiesStream);
                    versionPropertiesAreLoaded = true;
                }
                finally {
                    versionPropertiesStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!versionPropertiesAreLoaded && logger.isTraceEnabled()) {
            logger.trace("Couldn't open version.properties");
        }
        if ((osName = System.getProperty("os.name")) != null && osName.startsWith("Mac")) {
            new AEGetURLEventHandler(this);
        }
    }

    public static LaunchArgHandler getInstance() {
        if (argHandler == null) {
            argHandler = new LaunchArgHandler();
        }
        return argHandler;
    }

    public int handleArgs(String[] args) {
        int returnAction = 1;
        int i = 0;
        while (i < args.length) {
            if (logger.isTraceEnabled()) {
                logger.trace("handling arg " + i);
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                this.handleVersionArg();
                returnAction = 0;
                break;
            }
            if (args[i].equals("--help") || args[i].equals("-h")) {
                this.handleHelpArg();
                returnAction = 0;
                break;
            }
            if (args[i].equals("--debug") || args[i].equals("-d")) {
                this.handleDebugArg(args[i]);
            } else {
                if (args[i].equals("--ipv6") || args[i].equals("-6")) {
                    this.handleIPv6Enforcement();
                    break;
                }
                if (args[i].equals("--ipv4") || args[i].equals("-4")) {
                    this.handleIPv4Enforcement();
                    break;
                }
                if (args[i].startsWith("--config=")) {
                    returnAction = this.handleConfigArg(args[i]);
                    if (returnAction == 2) {
                        break;
                    }
                } else if (args[i].equals("-c")) {
                    if (i == args.length - 1) {
                        System.out.println("The \"-c\" option expects a directory parameter.");
                        returnAction = 2;
                        break;
                    }
                    this.handleConfigArg(args[++i]);
                } else if (args[i].equals("--multiple") || args[i].equals("-m")) {
                    returnAction = 3;
                } else if (!args[i].startsWith("--splash=")) {
                    if (i == args.length - 1 && !args[i].startsWith("-")) {
                        this.handleUri(args[i]);
                    } else {
                        this.handleUnknownArg(args[i]);
                        this.errorCode = 1;
                        returnAction = 2;
                        break;
                    }
                }
            }
            ++i;
        }
        return returnAction;
    }

    private void handleIPv6Enforcement() {
        System.setProperty("java.net.preferIPv4Stack", "false");
        System.setProperty("java.net.preferIPv6Addresses", "true");
    }

    private void handleIPv4Enforcement() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("java.net.preferIPv6Addresses", "false");
    }

    private void handleUri(String uri) {
        if (logger.isTraceEnabled()) {
            logger.trace("Handling uri " + uri);
        }
        this.argDelegator.handleUri(uri);
    }

    private void handleDebugArg(String arg) {
        ScStdOut.setStdOutPrintingEnabled(true);
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getAnonymousLogger().getParent();
        ConsoleHandler conHan = null;
        Handler[] handlerArray = rootLogger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof ConsoleHandler) {
                conHan = (ConsoleHandler)handler;
                break;
            }
            ++n2;
        }
        if (conHan == null) {
            conHan = new ConsoleHandler();
            rootLogger.addHandler(conHan);
        }
    }

    private int handleConfigArg(String configArg) {
        if (configArg.startsWith("--config=")) {
            configArg = configArg.substring("--config=".length());
        }
        File configDir = new File(configArg);
        configDir.mkdirs();
        if (!configDir.isDirectory()) {
            System.out.println("Failed to create directory " + configArg);
            this.errorCode = 3;
            return 2;
        }
        System.setProperty(PNAME_SC_HOME_DIR_LOCATION, configDir.getParent());
        System.setProperty(PNAME_SC_CACHE_DIR_LOCATION, configDir.getParent());
        System.setProperty(PNAME_SC_LOG_DIR_LOCATION, configDir.getParent());
        System.setProperty(PNAME_SC_HOME_DIR_NAME, configDir.getName());
        logger.reset();
        return 1;
    }

    private void handleVersionArg() {
        String name = this.getApplicationName();
        String version = this.getVersion();
        if (name == null || name.trim().length() == 0) {
            name = "Jitsi";
        }
        if (version == null || version.trim().length() == 0) {
            version = "build.by.SVN";
        }
        System.out.println(String.valueOf(name) + " " + version);
    }

    private String getVersion() {
        String version = this.versionProperties.getProperty(PNAME_VERSION);
        return version == null ? "build.by.SVN" : version;
    }

    private String getApplicationName() {
        String name = this.versionProperties.getProperty(PNAME_APPLICATION_NAME);
        return name == null ? "Jitsi" : name;
    }

    private String getPackageName() {
        String name = this.versionProperties.getProperty(PNAME_PACKAGE_NAME);
        return name == null ? "jitsi" : name;
    }

    public void handleUnknownArg(String arg) {
        System.out.println("Unknown argument: " + arg);
        this.handleHelpArg();
    }

    public void handleHelpArg() {
        this.handleVersionArg();
        System.out.println("Usage: " + this.getPackageName() + " [OPTIONS] [uri-to-call]");
        System.out.println("");
        System.out.println("  -c, --config=DIR  use DIR for config files");
        System.out.println("  -d, --debug       print debugging messages to stdout");
        System.out.println("  -h, --help        display this help message and exit");
        System.out.println("  -m, --multiple    do not ensure single instance");
        System.out.println("  -6, --ipv6        prefer IPv6 addresses where possible only");
        System.out.println("  -4, --ipv4        forces use of IPv4 only");
        System.out.println("  -v, --version     display the current version and exit");
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setDelegationPeer(ArgDelegationPeer delegationPeer) {
        this.argDelegator.setDelegationPeer(delegationPeer);
    }

    public void handleConcurrentInvocationRequestArgs(String[] args) {
        if (args.length >= 1 && !args[args.length - 1].startsWith("-")) {
            this.argDelegator.handleUri(args[args.length - 1]);
        } else {
            this.argDelegator.handleConcurrentInvocationRequest();
        }
    }
}

