/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Iterator;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.net.ConnProcessorExceptionEvent;
import net.kano.joscar.net.ConnProcessorExceptionHandler;

public abstract class ConnProcessorImpl
implements ConnProcessor {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.net");
    private boolean attached = false;
    private InputStream in = null;
    private OutputStream out = null;
    private final CopyOnWriteArrayList<ConnProcessorExceptionHandler> errorHandlers = new CopyOnWriteArrayList();

    public final synchronized void attachToSocket(Socket socket) throws IOException {
        DefensiveTools.checkNull((Object)socket, (String)"socket");
        this.attachToInput(socket.getInputStream());
        this.attachToOutput(socket.getOutputStream());
    }

    public final synchronized void attachToInput(InputStream in) {
        DefensiveTools.checkNull((Object)in, (String)"in");
        this.in = in;
        this.attached = true;
    }

    public final synchronized void attachToOutput(OutputStream out) {
        DefensiveTools.checkNull((Object)out, (String)"out");
        this.out = out;
        this.attached = true;
    }

    protected final synchronized boolean isAttached() {
        return this.attached;
    }

    protected final synchronized InputStream getInputStream() {
        return this.in;
    }

    protected final synchronized OutputStream getOutputStream() {
        return this.out;
    }

    public final synchronized void detach() {
        this.in = null;
        this.out = null;
        this.attached = false;
    }

    public final void addExceptionHandler(ConnProcessorExceptionHandler handler) {
        DefensiveTools.checkNull((Object)handler, (String)"handler");
        this.errorHandlers.addIfAbsent((Object)handler);
    }

    public final void removeExceptionHandler(ConnProcessorExceptionHandler handler) {
        DefensiveTools.checkNull((Object)handler, (String)"handler");
        this.errorHandlers.remove((Object)handler);
    }

    public final void handleException(ConnProcessor.ErrorType type, Throwable t) {
        this.handleException(type, t, null);
    }

    public final void handleException(ConnProcessor.ErrorType type, Throwable t, Object info) {
        DefensiveTools.checkNull((Object)type, (String)"type");
        DefensiveTools.checkNull((Object)t, (String)"t");
        boolean logFine = logger.logFineEnabled();
        boolean logFiner = logger.logFinerEnabled();
        if (logFine) {
            logger.logFine("Processing connection error (" + type + "): " + t.getMessage() + ": " + info);
        }
        if (type == ConnProcessorExceptionEvent.ERRTYPE_CONNECTION_ERROR && !this.isAttached()) {
            if (logFiner) {
                logger.logFine("Ignoring " + type + " connection error because " + "processor is not attached");
            }
            return;
        }
        Iterator iterator = this.errorHandlers.iterator();
        if (!iterator.hasNext()) {
            if (logger.logWarningEnabled()) {
                logger.logException("CONNPROCESSOR HAS NO ERROR HANDLERS, DUMPING:\nERROR TYPE: " + type + "\n" + "ERROR INFO: " + info, t);
            }
            return;
        }
        ConnProcessorExceptionEvent event = new ConnProcessorExceptionEvent(this, type, t, info);
        while (iterator.hasNext()) {
            ConnProcessorExceptionHandler handler = (ConnProcessorExceptionHandler)iterator.next();
            if (logFiner) {
                logger.logFiner("Running ConnProcessor error handler " + handler);
            }
            try {
                handler.handleException(event);
            }
            catch (Throwable t2) {
                if (!logger.logWarningEnabled()) continue;
                logger.logWarning("Exception handler " + handler + "threw exception: " + t2);
            }
        }
    }
}

