/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetWhiteboardingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.WhiteboardParticipantJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectCircleJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectImageJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectLineJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPathJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPolyLineJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPolygonJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectRectJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectTextJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardSessionPacketExtension;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.WhiteboardParticipant;
import net.java.sip.communicator.service.protocol.WhiteboardParticipantState;
import net.java.sip.communicator.service.protocol.WhiteboardSession;
import net.java.sip.communicator.service.protocol.WhiteboardSessionState;
import net.java.sip.communicator.service.protocol.event.WhiteboardChangeEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardChangeListener;
import net.java.sip.communicator.service.protocol.event.WhiteboardObjectDeletedEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardObjectDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardObjectDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardObjectListener;
import net.java.sip.communicator.service.protocol.event.WhiteboardObjectModifiedEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardObjectReceivedEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardParticipantChangeEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardParticipantEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardParticipantListener;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObject;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectCircle;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectImage;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectLine;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectPath;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectPolyLine;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectPolygon;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectRect;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectText;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.MessageEventManager;
import org.jivesoftware.smackx.packet.MessageEvent;

public class WhiteboardSessionJabberImpl
implements WhiteboardParticipantListener,
WhiteboardSession {
    private static final Logger logger = Logger.getLogger(WhiteboardSessionJabberImpl.class);
    private Vector<WhiteboardObjectListener> messageListeners = new Vector();
    private Hashtable<String, WhiteboardParticipant> wbParticipants = new Hashtable();
    private WhiteboardSessionState whiteboardState = WhiteboardSessionState.WHITEBOARD_INITIALIZATION;
    private ProtocolProviderServiceJabberImpl jabberProvider = null;
    private String whiteboardID = null;
    private Vector<WhiteboardChangeListener> whiteboardListeners = new Vector();
    private final Vector<WhiteboardObject> whiteboardObjects = new Vector();
    private OperationSetWhiteboardingJabberImpl whiteboardOpSet;
    private Chat smackChat;

    public WhiteboardSessionJabberImpl(ProtocolProviderServiceJabberImpl sourceProvider, OperationSetWhiteboardingJabberImpl opSet) {
        this.jabberProvider = sourceProvider;
        this.whiteboardOpSet = opSet;
        this.whiteboardID = String.valueOf(String.valueOf(System.currentTimeMillis())) + String.valueOf(super.hashCode());
    }

    public Iterator<WhiteboardParticipant> getWhiteboardParticipants() {
        return new LinkedList<WhiteboardParticipant>(this.wbParticipants.values()).iterator();
    }

    public int getWhiteboardParticipantsCount() {
        return this.wbParticipants.size();
    }

    public void join() throws OperationFailedException {
        PacketExtensionFilter filterWhiteboard = new PacketExtensionFilter("http://jabber.org/protocol/swb");
        this.jabberProvider.getConnection().addPacketListener((PacketListener)new WhiteboardSmackMessageListener(), (PacketFilter)filterWhiteboard);
        this.whiteboardOpSet.fireWhiteboardSessionPresenceEvent(this, "LocalUserJoined", null);
    }

    public void join(byte[] password) throws OperationFailedException {
    }

    public boolean isJoined() {
        return true;
    }

    public void leave() {
        try {
            this.assertConnected();
            Message msg = new Message();
            WhiteboardSessionPacketExtension extension = new WhiteboardSessionPacketExtension(this, this.jabberProvider.getAccountID().getAccountAddress(), "LEAVE");
            msg.addExtension((PacketExtension)extension);
            MessageEventManager.addNotificationsRequests((Message)msg, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            this.smackChat.sendMessage(msg);
        }
        catch (XMPPException ex) {
            ex.printStackTrace();
            logger.error((Object)"message not send", (Throwable)ex);
        }
        this.whiteboardOpSet.fireWhiteboardSessionPresenceEvent(this, "LocalUserLeft", null);
    }

    public void invite(String contactAddress) {
        OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)this.jabberProvider.getOperationSet(OperationSetPresence.class);
        if (presenceOpSet == null) {
            return;
        }
        ContactJabberImpl sourceContact = (ContactJabberImpl)presenceOpSet.findContactByID(contactAddress);
        if (sourceContact == null) {
            sourceContact = presenceOpSet.createVolatileContact(contactAddress);
        }
        this.addWhiteboardParticipant(new WhiteboardParticipantJabberImpl(sourceContact, this));
        try {
            this.sendWhiteboardObject(this.createWhiteboardObject("WHITEBOARDOBJECTLINE"));
        }
        catch (OperationFailedException e) {
            logger.error((Object)"Could not send an invite whiteboard object.", (Throwable)e);
        }
    }

    public WhiteboardSession getWhiteboardSession() {
        return this;
    }

    public void participantStateChanged(WhiteboardParticipantChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (newValue == WhiteboardParticipantState.DISCONNECTED || newValue == WhiteboardParticipantState.FAILED) {
            this.removeWhiteboardParticipant(evt.getSourceWhiteboardParticipant());
        }
    }

    public void participantDisplayNameChanged(WhiteboardParticipantChangeEvent evt) {
    }

    public void participantAddressChanged(WhiteboardParticipantChangeEvent evt) {
    }

    public void participantTransportAddressChanged(WhiteboardParticipantChangeEvent evt) {
    }

    public void participantImageChanged(WhiteboardParticipantChangeEvent evt) {
    }

    public void addWhiteboardParticipant(WhiteboardParticipant wbParticipant) {
        if (this.wbParticipants.containsKey(wbParticipant.getContactAddress())) {
            return;
        }
        wbParticipant.addWhiteboardParticipantListener((WhiteboardParticipantListener)this);
        this.wbParticipants.put(wbParticipant.getContactAddress(), wbParticipant);
        this.smackChat = this.jabberProvider.getConnection().getChatManager().createChat(wbParticipant.getContactAddress(), null);
        this.fireWhiteboardParticipantEvent(wbParticipant, 1);
    }

    public void removeWhiteboardParticipant(WhiteboardParticipant wbParticipant) {
        if (!this.wbParticipants.containsKey(wbParticipant.getContactAddress())) {
            return;
        }
        this.wbParticipants.remove(wbParticipant.getContactAddress());
        if (wbParticipant instanceof WhiteboardParticipantJabberImpl) {
            ((WhiteboardParticipantJabberImpl)wbParticipant).setWhiteboardSession(null);
        }
        wbParticipant.removeWhiteboardParticipantListener((WhiteboardParticipantListener)this);
        this.fireWhiteboardParticipantEvent(wbParticipant, 2);
        if (this.wbParticipants.isEmpty()) {
            this.setWhiteboardSessionState(WhiteboardSessionState.WHITEBOARD_ENDED);
        }
    }

    public void setWhiteboardSessionState(WhiteboardSessionState newState) {
        WhiteboardSessionState oldState = this.getWhiteboardSessionState();
        if (oldState == newState) {
            return;
        }
        this.whiteboardState = newState;
        this.fireWhiteboardChangeEvent("WhiteboardState", oldState, newState);
    }

    public WhiteboardSessionState getWhiteboardSessionState() {
        return this.whiteboardState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWhiteboardObjectListener(WhiteboardObjectListener listener) {
        Vector<WhiteboardObjectListener> vector = this.messageListeners;
        synchronized (vector) {
            if (!this.messageListeners.contains(listener)) {
                this.messageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWhiteboardObjectListener(WhiteboardObjectListener listener) {
        Vector<WhiteboardObjectListener> vector = this.messageListeners;
        synchronized (vector) {
            this.messageListeners.remove(listener);
        }
    }

    public WhiteboardObject createWhiteboardObject(String name) {
        WhiteboardObjectJabberImpl wbObj = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[log] WhiteboardObjectXXX.NAME: " + name));
        }
        if (name.equals("WHITEBOARDOBJECTPATH")) {
            wbObj = new WhiteboardObjectPathJabberImpl();
        } else if (name.equals("WHITEBOARDOBJECTPOLYLINE")) {
            wbObj = new WhiteboardObjectPolyLineJabberImpl();
        } else if (name.equals("WHITEBOARDOBJECTPOLYGON")) {
            wbObj = new WhiteboardObjectPolygonJabberImpl();
        } else if (name.equals("WHITEBOARDOBJECTLINE")) {
            wbObj = new WhiteboardObjectLineJabberImpl();
        } else if (name.equals("WHITEBOARDOBJECTRECT")) {
            wbObj = new WhiteboardObjectRectJabberImpl();
        } else if (name.equals("WHITEBOARDOBJECTCIRCLE")) {
            wbObj = new WhiteboardObjectCircleJabberImpl();
        } else if (name.equals("WHITEBOARDOBJECTTEXT")) {
            wbObj = new WhiteboardObjectTextJabberImpl();
        } else if (name.equals("WHITEBOARDOBJECTIMAGE")) {
            wbObj = new WhiteboardObjectImageJabberImpl();
        }
        this.whiteboardObjects.add(wbObj);
        return wbObj;
    }

    public String getWhiteboardID() {
        return this.whiteboardID;
    }

    public boolean isOfflineMessagingSupported() {
        return true;
    }

    public void moveWhiteboardObject(WhiteboardObject obj) throws OperationFailedException {
        WhiteboardObject wbObj = this.updateWhiteboardObjects(obj);
        if (wbObj != null) {
            this.sendWhiteboardObject(wbObj);
        }
    }

    public void deleteWhiteboardObject(WhiteboardObject obj) throws OperationFailedException {
        Iterator<WhiteboardParticipant> participants = this.getWhiteboardParticipants();
        if (!participants.hasNext()) {
            return;
        }
        WhiteboardParticipantJabberImpl participant = (WhiteboardParticipantJabberImpl)participants.next();
        Contact contact = participant.getContact();
        try {
            this.assertConnected();
            Message msg = new Message();
            WhiteboardObjectPacketExtension messageJI = new WhiteboardObjectPacketExtension(obj.getID(), "DELETE");
            msg.addExtension((PacketExtension)messageJI);
            MessageEventManager.addNotificationsRequests((Message)msg, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            this.smackChat.sendMessage(msg);
            WhiteboardObjectDeliveredEvent msgDeliveredEvt = new WhiteboardObjectDeliveredEvent((WhiteboardSession)this, obj, contact, new Date());
            this.fireMessageEvent((EventObject)msgDeliveredEvt);
            int i = 0;
            while (i < this.whiteboardObjects.size()) {
                WhiteboardObjectJabberImpl wbObj = (WhiteboardObjectJabberImpl)this.whiteboardObjects.get(i);
                if (wbObj.getID().equals(obj.getID())) {
                    this.whiteboardObjects.remove(i);
                    continue;
                }
                ++i;
            }
        }
        catch (XMPPException ex) {
            ex.printStackTrace();
            logger.error((Object)"message not send", (Throwable)ex);
        }
    }

    public void sendWhiteboardObject(WhiteboardObject message) throws OperationFailedException {
        Iterator<WhiteboardParticipant> participants = this.getWhiteboardParticipants();
        if (!participants.hasNext()) {
            return;
        }
        WhiteboardParticipantJabberImpl participant = (WhiteboardParticipantJabberImpl)participants.next();
        Contact contact = participant.getContact();
        try {
            this.assertConnected();
            Message msg = new Message();
            WhiteboardObjectPacketExtension messageJI = new WhiteboardObjectPacketExtension((WhiteboardObjectJabberImpl)message, "DRAW");
            msg.addExtension((PacketExtension)messageJI);
            MessageEventManager.addNotificationsRequests((Message)msg, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            this.smackChat.sendMessage(msg);
            WhiteboardObjectDeliveredEvent msgDeliveredEvt = new WhiteboardObjectDeliveredEvent((WhiteboardSession)this, message, contact, new Date());
            this.fireMessageEvent((EventObject)msgDeliveredEvt);
        }
        catch (XMPPException ex) {
            ex.printStackTrace();
            logger.error((Object)"message not send", (Throwable)ex);
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.jabberProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to communicate.");
        }
        if (!this.jabberProvider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WhiteboardSession)) {
            return false;
        }
        return obj == this || ((WhiteboardSession)obj).getWhiteboardID().equals(this.getWhiteboardID());
    }

    public int hashCode() {
        return this.getWhiteboardID().hashCode();
    }

    public String toString() {
        return "Whiteboard: id=" + this.getWhiteboardID() + " participants=" + this.getWhiteboardParticipantsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWhiteboardChangeListener(WhiteboardChangeListener listener) {
        Vector<WhiteboardChangeListener> vector = this.whiteboardListeners;
        synchronized (vector) {
            if (!this.whiteboardListeners.contains(listener)) {
                this.whiteboardListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWhiteboardChangeListener(WhiteboardChangeListener listener) {
        Vector<WhiteboardChangeListener> vector = this.whiteboardListeners;
        synchronized (vector) {
            this.whiteboardListeners.remove(listener);
        }
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.jabberProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWhiteboardParticipantEvent(WhiteboardParticipant sourceWhiteboardParticipant, int eventID) {
        ArrayList<WhiteboardChangeListener> listeners;
        WhiteboardParticipantEvent cpEvent = new WhiteboardParticipantEvent((WhiteboardSession)this, sourceWhiteboardParticipant, eventID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a WhiteboardParticipant event to " + this.whiteboardListeners.size() + " listeners. event is: " + cpEvent.toString()));
        }
        Vector<WhiteboardChangeListener> vector = this.whiteboardListeners;
        synchronized (vector) {
            listeners = new ArrayList<WhiteboardChangeListener>(this.whiteboardListeners);
        }
        for (WhiteboardChangeListener listener : listeners) {
            if (eventID == 1) {
                listener.whiteboardParticipantAdded(cpEvent);
                continue;
            }
            if (eventID != 2) continue;
            listener.whiteboardParticipantRemoved(cpEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWhiteboardChangeEvent(String type, Object oldValue, Object newValue) {
        ArrayList<WhiteboardChangeListener> listeners;
        WhiteboardChangeEvent ccEvent = new WhiteboardChangeEvent((WhiteboardSession)this, type, oldValue, newValue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a WhiteboardChange event to " + this.whiteboardListeners.size() + " listeners. event is: " + ccEvent.toString()));
        }
        Vector<WhiteboardChangeListener> vector = this.whiteboardListeners;
        synchronized (vector) {
            listeners = new ArrayList<WhiteboardChangeListener>(this.whiteboardListeners);
        }
        for (WhiteboardChangeListener listener : listeners) {
            if (!type.equals("WhiteboardState")) continue;
            listener.whiteboardStateChanged(ccEvent);
        }
    }

    public Vector<WhiteboardObject> getWhiteboardObjects() {
        return this.whiteboardObjects;
    }

    public void setState(WhiteboardSessionState newState) {
        this.whiteboardState = newState;
    }

    public WhiteboardSessionState getState() {
        return this.whiteboardState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageEvent(EventObject evt) {
        ArrayList<WhiteboardObjectListener> listeners;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a WhiteboardMessageEvent event to " + this.messageListeners.size() + " listeners. event is: " + evt.toString()));
        }
        Vector<WhiteboardObjectListener> vector = this.messageListeners;
        synchronized (vector) {
            listeners = new ArrayList<WhiteboardObjectListener>(this.messageListeners);
        }
        for (WhiteboardObjectListener listener : listeners) {
            if (evt instanceof WhiteboardObjectDeliveredEvent) {
                listener.whiteboardObjectDelivered((WhiteboardObjectDeliveredEvent)evt);
                continue;
            }
            if (evt instanceof WhiteboardObjectReceivedEvent) {
                WhiteboardObjectJabberImpl wbObj = (WhiteboardObjectJabberImpl)((WhiteboardObjectReceivedEvent)evt).getSourceWhiteboardObject();
                listener.whiteboardObjectReceived((WhiteboardObjectReceivedEvent)evt);
                this.whiteboardObjects.add(wbObj);
                continue;
            }
            if (evt instanceof WhiteboardObjectDeletedEvent) {
                String wbObjID = ((WhiteboardObjectDeletedEvent)evt).getId();
                listener.whiteboardObjectDeleted((WhiteboardObjectDeletedEvent)evt);
                int i = 0;
                while (i < this.whiteboardObjects.size()) {
                    WhiteboardObjectJabberImpl wbObj = (WhiteboardObjectJabberImpl)this.whiteboardObjects.get(i);
                    if (wbObj.getID().equals(wbObjID)) {
                        this.whiteboardObjects.remove(i);
                        continue;
                    }
                    ++i;
                }
                continue;
            }
            if (evt instanceof WhiteboardObjectModifiedEvent) {
                WhiteboardObjectModifiedEvent womevt = (WhiteboardObjectModifiedEvent)evt;
                WhiteboardObjectJabberImpl wbObj = (WhiteboardObjectJabberImpl)womevt.getSourceWhiteboardObject();
                listener.whiteboardObjecModified(womevt);
                this.whiteboardObjects.remove(wbObj);
                this.whiteboardObjects.add(wbObj);
                continue;
            }
            if (!(evt instanceof WhiteboardObjectDeliveryFailedEvent)) continue;
            listener.whiteboardObjectDeliveryFailed((WhiteboardObjectDeliveryFailedEvent)evt);
        }
    }

    private WhiteboardObject updateWhiteboardObjects(WhiteboardObject ws) {
        WhiteboardObjectJabberImpl obj;
        WhiteboardObjectJabberImpl wbObj = null;
        int i = 0;
        while (i < this.whiteboardObjects.size()) {
            WhiteboardObjectJabberImpl wbObjTmp = (WhiteboardObjectJabberImpl)this.whiteboardObjects.get(i);
            if (wbObjTmp.getID().equals(ws.getID())) {
                wbObj = wbObjTmp;
                break;
            }
            ++i;
        }
        if (wbObj == null) {
            return null;
        }
        if (ws instanceof WhiteboardObjectPath) {
            obj = (WhiteboardObjectPathJabberImpl)wbObj;
            ((WhiteboardObjectPathJabberImpl)obj).setPoints(((WhiteboardObjectPath)ws).getPoints());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        } else if (ws instanceof WhiteboardObjectPolyLine) {
            obj = (WhiteboardObjectPolyLineJabberImpl)wbObj;
            ((WhiteboardObjectPolyLineJabberImpl)obj).setPoints(((WhiteboardObjectPolyLine)ws).getPoints());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        } else if (ws instanceof WhiteboardObjectPolygon) {
            obj = (WhiteboardObjectPolygonJabberImpl)wbObj;
            ((WhiteboardObjectPolygonJabberImpl)obj).setPoints(((WhiteboardObjectPolygon)ws).getPoints());
            ((WhiteboardObjectPolygonJabberImpl)obj).setBackgroundColor(((WhiteboardObjectPolygon)ws).getBackgroundColor());
            ((WhiteboardObjectPolygonJabberImpl)obj).setFill(((WhiteboardObjectPolygon)ws).isFill());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        } else if (ws instanceof WhiteboardObjectLine) {
            obj = (WhiteboardObjectLineJabberImpl)wbObj;
            ((WhiteboardObjectLineJabberImpl)obj).setWhiteboardPointStart(((WhiteboardObjectLine)ws).getWhiteboardPointStart());
            ((WhiteboardObjectLineJabberImpl)obj).setWhiteboardPointEnd(((WhiteboardObjectLine)ws).getWhiteboardPointEnd());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        } else if (ws instanceof WhiteboardObjectRect) {
            obj = (WhiteboardObjectRectJabberImpl)wbObj;
            ((WhiteboardObjectRectJabberImpl)obj).setFill(((WhiteboardObjectRect)ws).isFill());
            ((WhiteboardObjectRectJabberImpl)obj).setHeight(((WhiteboardObjectRect)ws).getHeight());
            ((WhiteboardObjectRectJabberImpl)obj).setWhiteboardPoint(((WhiteboardObjectRect)ws).getWhiteboardPoint());
            ((WhiteboardObjectRectJabberImpl)obj).setWidth(((WhiteboardObjectRect)ws).getWidth());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        } else if (ws instanceof WhiteboardObjectCircle) {
            obj = (WhiteboardObjectCircleJabberImpl)wbObj;
            ((WhiteboardObjectCircleJabberImpl)obj).setFill(((WhiteboardObjectCircle)ws).isFill());
            ((WhiteboardObjectCircleJabberImpl)obj).setRadius(((WhiteboardObjectCircle)ws).getRadius());
            ((WhiteboardObjectCircleJabberImpl)obj).setWhiteboardPoint(((WhiteboardObjectCircle)ws).getWhiteboardPoint());
            ((WhiteboardObjectCircleJabberImpl)obj).setBackgroundColor(((WhiteboardObjectCircle)ws).getBackgroundColor());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        } else if (ws instanceof WhiteboardObjectText) {
            obj = (WhiteboardObjectTextJabberImpl)wbObj;
            ((WhiteboardObjectTextJabberImpl)obj).setFontName(((WhiteboardObjectText)ws).getFontName());
            ((WhiteboardObjectTextJabberImpl)obj).setFontSize(((WhiteboardObjectText)ws).getFontSize());
            ((WhiteboardObjectTextJabberImpl)obj).setText(((WhiteboardObjectText)ws).getText());
            ((WhiteboardObjectTextJabberImpl)obj).setWhiteboardPoint(((WhiteboardObjectText)ws).getWhiteboardPoint());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        } else if (ws instanceof WhiteboardObjectImage) {
            obj = (WhiteboardObjectImageJabberImpl)wbObj;
            ((WhiteboardObjectImageJabberImpl)obj).setBackgroundImage(((WhiteboardObjectImage)ws).getBackgroundImage());
            ((WhiteboardObjectImageJabberImpl)obj).setHeight(((WhiteboardObjectImage)ws).getHeight());
            ((WhiteboardObjectImageJabberImpl)obj).setWhiteboardPoint(((WhiteboardObjectImage)ws).getWhiteboardPoint());
            ((WhiteboardObjectImageJabberImpl)obj).setWidth(((WhiteboardObjectImage)ws).getWidth());
            obj.setColor(ws.getColor());
            obj.setThickness(ws.getThickness());
        }
        this.whiteboardObjects.set(i, wbObj);
        return wbObj;
    }

    public String[] getSupportedWhiteboardObjects() {
        String[] type = new String[]{"WHITEBOARDOBJECTPATH", "WHITEBOARDOBJECTPOLYLINE", "WHITEBOARDOBJECTPOLYGON", "WHITEBOARDOBJECTLINE", "WHITEBOARDOBJECTRECT", "WHITEBOARDOBJECTCIRCLE", "WHITEBOARDOBJECTTEXT", "WHITEBOARDOBJECTIMAGE"};
        return type;
    }

    public boolean isParticipantContained(String participantName) {
        return this.wbParticipants.containsKey(participantName);
    }

    private WhiteboardParticipant findWhiteboardParticipantFromContactAddress(String contactAddress) {
        for (WhiteboardParticipant participant : this.wbParticipants.values()) {
            if (!participant.getContactAddress().equals(contactAddress)) continue;
            return participant;
        }
        return null;
    }

    private class WhiteboardSmackMessageListener
    implements PacketListener {
        private WhiteboardSmackMessageListener() {
        }

        public void processPacket(Packet packet) {
            OperationSetPersistentPresenceJabberImpl presenceOpSet;
            WhiteboardSessionPacketExtension sessionMessage;
            if (!(packet instanceof Message)) {
                return;
            }
            PacketExtension objectExt = packet.getExtension("xObject", "http://jabber.org/protocol/swb");
            PacketExtension sessionExt = packet.getExtension("xSession", "http://jabber.org/protocol/swb");
            Message msg = (Message)packet;
            if (sessionExt != null && (sessionMessage = (WhiteboardSessionPacketExtension)sessionExt).getAction().equals("LEAVE")) {
                WhiteboardSessionJabberImpl.this.fireWhiteboardParticipantEvent(WhiteboardSessionJabberImpl.this.findWhiteboardParticipantFromContactAddress(sessionMessage.getContactAddress()), 2);
            }
            if (objectExt == null) {
                return;
            }
            String fromUserID = StringUtils.parseBareAddress((String)msg.getFrom());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received from " + fromUserID + " the message " + msg.toXML()));
            }
            if ((presenceOpSet = (OperationSetPersistentPresenceJabberImpl)WhiteboardSessionJabberImpl.this.jabberProvider.getOperationSet(OperationSetPresence.class)) == null) {
                return;
            }
            Contact sourceContact = presenceOpSet.findContactByID(fromUserID);
            if (!WhiteboardSessionJabberImpl.this.wbParticipants.containsKey(sourceContact.getAddress())) {
                return;
            }
            WhiteboardObjectPacketExtension newMessage = (WhiteboardObjectPacketExtension)objectExt;
            if (msg.getType() == Message.Type.error) {
                MessageEvent msgEvent;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("WBObject error received from " + fromUserID));
                }
                int errorCode = packet.getError().getCode();
                int errorResultCode = 1;
                if (errorCode == 503 && (msgEvent = (MessageEvent)packet.getExtension("x", "jabber:x:event")) != null && msgEvent.isOffline()) {
                    errorResultCode = 5;
                }
                WhiteboardObjectDeliveryFailedEvent evt = new WhiteboardObjectDeliveryFailedEvent((WhiteboardSession)WhiteboardSessionJabberImpl.this, (WhiteboardObject)newMessage.getWhiteboardObject(), sourceContact, errorResultCode, new Date());
                WhiteboardSessionJabberImpl.this.fireMessageEvent((EventObject)evt);
                return;
            }
            if (newMessage.getAction().equals("DELETE")) {
                WhiteboardObjectDeletedEvent msgDeletedEvt = new WhiteboardObjectDeletedEvent((WhiteboardSession)WhiteboardSessionJabberImpl.this, newMessage.getWhiteboardObjectID(), sourceContact, new Date());
                WhiteboardSessionJabberImpl.this.fireMessageEvent((EventObject)msgDeletedEvt);
            } else if (newMessage.getAction().equals("DRAW")) {
                WhiteboardObjectReceivedEvent msgReceivedEvt = new WhiteboardObjectReceivedEvent((WhiteboardSession)WhiteboardSessionJabberImpl.this, (WhiteboardObject)newMessage.getWhiteboardObject(), sourceContact, new Date());
                WhiteboardSessionJabberImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
            }
        }
    }
}

