/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.math.BigInteger;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509TrustManager;
import net.java.sip.communicator.impl.protocol.jabber.FailoverConnectionMonitor;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.JabberLoginStrategy;
import net.java.sip.communicator.impl.protocol.jabber.JingleNodesServiceDiscovery;
import net.java.sip.communicator.impl.protocol.jabber.LoginByClientCertificateStrategy;
import net.java.sip.communicator.impl.protocol.jabber.LoginByPasswordStrategy;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetAutoAnswerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetAvatarJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicInstantMessagingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetChangePasswordJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetContactCapabilitiesJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetCusaxUtilsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDTMFJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopSharingClientJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopSharingServerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopStreamingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetExtendedAuthorizationsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetGenericNotificationsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresencePermissionsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetResAwareTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetServerStoredAccountInfoJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetServerStoredContactInfoJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetTelephonyConferencingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetThumbnailedFileFactoryImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetTypingNotificationsJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetUserSearchJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetVideoBridgeImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetVideoTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetWhiteboardingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolIconJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProviderManagerExt;
import net.java.sip.communicator.impl.protocol.jabber.ScServiceDiscoveryManager;
import net.java.sip.communicator.impl.protocol.jabber.debugger.SmackPacketDebugger;
import net.java.sip.communicator.impl.protocol.jabber.extensions.ConferenceDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager;
import net.java.sip.communicator.impl.protocol.jabber.extensions.carbon.CarbonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.CoinIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.InputEvtIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingleinfo.JingleInfoQueryIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.keepalive.KeepAliveManager;
import net.java.sip.communicator.impl.protocol.jabber.extensions.version.VersionManager;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.dns.DnssecException;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.JingleNodeDescriptor;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetAvatar;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetChangePassword;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetCusaxUtils;
import net.java.sip.communicator.service.protocol.OperationSetDTMF;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetGenericNotifications;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransformImpl;
import net.java.sip.communicator.service.protocol.OperationSetMessageCorrection;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresencePermissions;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetResourceAwareTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureSDesTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureZrtpTelephony;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.OperationSetThumbnailedFileFactory;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.OperationSetUserSearch;
import net.java.sip.communicator.service.protocol.OperationSetVideoBridge;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.OperationSetWhiteboarding;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ProxyInfo;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.jabberconstants.JabberStatusEnum;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.SRVRecord;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.util.OSUtils;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.XHTMLManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.provider.DelayInformationProvider;
import org.osgi.framework.ServiceReference;
import org.xmpp.jnodes.smack.SmackServiceNode;
import org.xmpp.jnodes.smack.TrackerEntry;

public class ProtocolProviderServiceJabberImpl
extends AbstractProtocolProviderService {
    private static final Logger logger = Logger.getLogger(ProtocolProviderServiceJabberImpl.class);
    public static final String URN_XMPP_JINGLE = "urn:xmpp:jingle:1";
    public static final String URN_XMPP_JINGLE_RTP = "urn:xmpp:jingle:apps:rtp:1";
    public static final String URN_XMPP_JINGLE_RTP_AUDIO = "urn:xmpp:jingle:apps:rtp:audio";
    public static final String URN_XMPP_JINGLE_RTP_VIDEO = "urn:xmpp:jingle:apps:rtp:video";
    public static final String URN_XMPP_JINGLE_RTP_ZRTP = "urn:xmpp:jingle:apps:rtp:zrtp:1";
    public static final String URN_XMPP_JINGLE_RAW_UDP_0 = "urn:xmpp:jingle:transports:raw-udp:1";
    public static final String URN_XMPP_JINGLE_ICE_UDP_1 = "urn:xmpp:jingle:transports:ice-udp:1";
    public static final String URN_XMPP_JINGLE_NODES = "http://jabber.org/protocol/jinglenodes";
    public static final String URN_XMPP_JINGLE_TRANSFER_0 = "urn:xmpp:jingle:transfer:0";
    public static final String URN_XMPP_JINGLE_COIN = "urn:xmpp:coin";
    public static final String URN_XMPP_JINGLE_DTLS_SRTP = "urn:xmpp:jingle:apps:dtls:0";
    public static final String URN_IETF_RFC_3264 = "urn:ietf:rfc:3264";
    public static final String URN_XMPP_JINGLE_RTP_HDREXT = "urn:xmpp:jingle:apps:rtp:rtp-hdrext:0";
    public static final String CAPS_GTALK_WEB_VOICE = "voice-v1";
    public static final String CAPS_GTALK_WEB_VIDEO = "video-v1";
    public static final String CAPS_GTALK_WEB_CAMERA = "camera-v1";
    public static final String URN_GOOGLE_VOICE = "http://www.google.com/xmpp/protocol/voice/v1";
    public static final String URN_GOOGLE_CAMERA = "http://www.google.com/xmpp/protocol/camera/v1";
    public static final String URN_GOOGLE_VIDEO = "http://www.google.com/xmpp/protocol/video/v1";
    public static final String URN_REGISTER = "jabber:iq:register";
    private static final String IS_DESKTOP_STREAMING_DISABLED = "net.java.sip.communicator.impl.protocol.jabber.DESKTOP_STREAMING_DISABLED";
    private static final String IS_CALLING_DISABLED = "net.java.sip.communicator.impl.protocol.jabber.CALLING_DISABLED";
    public static final int SMACK_PACKET_REPLY_TIMEOUT = 45000;
    public static final String VCARD_REPLY_TIMEOUT_PROPERTY = "net.java.sip.communicator.impl.protocol.jabber.VCARD_REPLY_TIMEOUT";
    private static final String XMPP_DSCP_PROPERTY = "net.java.sip.communicator.impl.protocol.XMPP_DSCP";
    private static final String IS_USER_SEARCH_ENABLED_PROPERTY = "USER_SEARCH_ENABLED";
    public static final String GOOGLE_VOICE_DOMAIN = "voice.google.com";
    private XMPPConnection connection;
    private boolean isInitialized = false;
    private final Object initializationLock = new Object();
    private AccountID accountID = null;
    private SecurityAuthority authority = null;
    private String resource = null;
    private ProtocolIconJabberImpl jabberIcon;
    private final List<String> supportedFeatures = new ArrayList<String>();
    private ScServiceDiscoveryManager discoveryManager = null;
    private OperationSetContactCapabilitiesJabberImpl opsetContactCapabilities;
    private JabberStatusEnum jabberStatusEnum;
    private CertificateService guiVerification;
    private boolean abortConnecting = false;
    private boolean inConnectAndLogin = false;
    private final Object connectAndLoginLock = new Object();
    private RegistrationStateChangeEvent eventDuringLogin;
    private JabberConnectionListener connectionListener;
    private ProxyInfo proxy;
    private static ProviderManager providerManager = null;
    private static Object providerCreationLock = new Object();
    private SmackPacketDebugger debugger = null;
    private SmackServiceNode jingleNodesServiceNode = null;
    private final Object jingleNodesSyncRoot = new Object();
    private UserCredentials userCredentials = null;
    private KeepAliveManager keepAliveManager = null;
    private VersionManager versionManager = null;

    static {
        if (OSUtils.IS_ANDROID) {
            ProtocolProviderServiceJabberImpl.loadJabberServiceClasses();
        }
    }

    public RegistrationState getRegistrationState() {
        if (this.connection == null) {
            return RegistrationState.UNREGISTERED;
        }
        if (this.connection.isConnected() && this.connection.isAuthenticated()) {
            return RegistrationState.REGISTERED;
        }
        return RegistrationState.UNREGISTERED;
    }

    private CertificateService getCertificateVerificationService() {
        ServiceReference guiVerifyReference;
        if (this.guiVerification == null && (guiVerifyReference = JabberActivator.getBundleContext().getServiceReference(CertificateService.class.getName())) != null) {
            this.guiVerification = (CertificateService)JabberActivator.getBundleContext().getService(guiVerifyReference);
        }
        return this.guiVerification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SecurityAuthority authority) throws OperationFailedException {
        block24: {
            if (authority == null) {
                throw new IllegalArgumentException("The register method needs a valid non-null authority impl  in order to be able and retrieve passwords.");
            }
            this.authority = authority;
            try {
                try {
                    this.abortConnecting = false;
                    Object object = this.connectAndLoginLock;
                    synchronized (object) {
                        this.inConnectAndLogin = true;
                    }
                    this.initializeConnectAndLogin(authority, 0);
                }
                catch (XMPPException ex) {
                    logger.error((Object)"Error registering", (Throwable)ex);
                    this.eventDuringLogin = null;
                    this.fireRegistrationStateChanged(ex);
                    Object object = this.connectAndLoginLock;
                    synchronized (object) {
                        if (this.eventDuringLogin != null) {
                            if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                                this.disconnectAndCleanConnection();
                            }
                            this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                            this.eventDuringLogin = null;
                            this.inConnectAndLogin = false;
                            return;
                        }
                        this.inConnectAndLogin = false;
                        break block24;
                    }
                }
            }
            catch (Throwable throwable) {
                Object object = this.connectAndLoginLock;
                synchronized (object) {
                    if (this.eventDuringLogin != null) {
                        if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                            this.disconnectAndCleanConnection();
                        }
                        this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                        this.eventDuringLogin = null;
                        this.inConnectAndLogin = false;
                        return;
                    }
                    this.inConnectAndLogin = false;
                }
                throw throwable;
            }
            Object object = this.connectAndLoginLock;
            synchronized (object) {
                if (this.eventDuringLogin != null) {
                    if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                        this.disconnectAndCleanConnection();
                    }
                    this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                    this.eventDuringLogin = null;
                    this.inConnectAndLogin = false;
                    return;
                }
                this.inConnectAndLogin = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reregister(int authReasonCode) {
        block30: {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Trying to reregister us!");
                }
                this.unregister(false);
                this.abortConnecting = false;
                Object object = this.connectAndLoginLock;
                synchronized (object) {
                    this.inConnectAndLogin = true;
                }
                this.initializeConnectAndLogin(this.authority, authReasonCode);
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Error ReRegistering", (Throwable)ex);
                this.eventDuringLogin = null;
                this.disconnectAndCleanConnection();
                this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 6, null);
                Object object = this.connectAndLoginLock;
                synchronized (object) {
                    if (this.eventDuringLogin != null) {
                        if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                            this.disconnectAndCleanConnection();
                        }
                        this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                        this.eventDuringLogin = null;
                        this.inConnectAndLogin = false;
                        return;
                    }
                    this.inConnectAndLogin = false;
                    break block30;
                }
            }
            catch (XMPPException ex) {
                Object object;
                try {
                    logger.error((Object)"Error ReRegistering", (Throwable)ex);
                    this.eventDuringLogin = null;
                    this.fireRegistrationStateChanged(ex);
                    object = this.connectAndLoginLock;
                }
                catch (Throwable throwable) {
                    Object object2 = this.connectAndLoginLock;
                    synchronized (object2) {
                        if (this.eventDuringLogin != null) {
                            if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                                this.disconnectAndCleanConnection();
                            }
                            this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                            this.eventDuringLogin = null;
                            this.inConnectAndLogin = false;
                            return;
                        }
                        this.inConnectAndLogin = false;
                    }
                    throw throwable;
                }
                synchronized (object) {
                    if (this.eventDuringLogin != null) {
                        if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                            this.disconnectAndCleanConnection();
                        }
                        this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                        this.eventDuringLogin = null;
                        this.inConnectAndLogin = false;
                        return;
                    }
                    this.inConnectAndLogin = false;
                    break block30;
                }
            }
            Object object = this.connectAndLoginLock;
            synchronized (object) {
                if (this.eventDuringLogin != null) {
                    if (this.eventDuringLogin.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) || this.eventDuringLogin.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                        this.disconnectAndCleanConnection();
                    }
                    this.fireRegistrationStateChanged(this.eventDuringLogin.getOldState(), this.eventDuringLogin.getNewState(), this.eventDuringLogin.getReasonCode(), this.eventDuringLogin.getReason());
                    this.eventDuringLogin = null;
                    this.inConnectAndLogin = false;
                    return;
                }
                this.inConnectAndLogin = false;
            }
        }
    }

    public boolean isSignalingTransportSecure() {
        return this.connection != null && this.connection.isUsingTLS();
    }

    public TransportProtocol getTransportProtocol() {
        if (this.connection != null && this.connection.isConnected()) {
            if (this.connection.isUsingTLS()) {
                return TransportProtocol.TLS;
            }
            return TransportProtocol.TCP;
        }
        return TransportProtocol.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConnectAndLogin(SecurityAuthority authority, int reasonCode) throws XMPPException, OperationFailedException {
        Object object = this.initializationLock;
        synchronized (object) {
            String customXMPPDomain;
            ConnectState state;
            if (this.isRegistered()) {
                return;
            }
            JabberLoginStrategy loginStrategy = this.createLoginStrategy();
            this.userCredentials = loginStrategy.prepareLogin(authority, reasonCode);
            if (!loginStrategy.loginPreparationSuccessful()) {
                return;
            }
            String serviceName = org.jivesoftware.smack.util.StringUtils.parseServer((String)this.getAccountID().getUserID());
            this.loadResource();
            this.loadProxy();
            Roster.setDefaultSubscriptionMode((Roster.SubscriptionMode)Roster.SubscriptionMode.manual);
            boolean[] hadDnsSecException = new boolean[1];
            boolean isServerOverriden = this.getAccountID().getAccountPropertyBoolean((Object)"IS_SERVER_OVERRIDDEN", false);
            if (!isServerOverriden) {
                state = this.connectUsingSRVRecords(serviceName, serviceName, hadDnsSecException, loginStrategy);
                if (hadDnsSecException[0]) {
                    this.setDnssecLoginFailure();
                    return;
                }
                if (state == ConnectState.ABORT_CONNECTING || state == ConnectState.STOP_TRYING) {
                    return;
                }
            }
            if ((customXMPPDomain = this.getAccountID().getAccountPropertyString((Object)"CUSTOM_XMPP_DOMAIN")) != null && !hadDnsSecException[0]) {
                logger.info((Object)("Connect using custom xmpp domain: " + customXMPPDomain));
                state = this.connectUsingSRVRecords(customXMPPDomain, serviceName, hadDnsSecException, loginStrategy);
                logger.info((Object)("state for connectUsingSRVRecords: " + (Object)((Object)state)));
                if (hadDnsSecException[0]) {
                    this.setDnssecLoginFailure();
                    return;
                }
                if (state == ConnectState.ABORT_CONNECTING || state == ConnectState.STOP_TRYING) {
                    return;
                }
            }
            String serverAddressUserSetting = this.getAccountID().getAccountPropertyString((Object)"SERVER_ADDRESS");
            int serverPort = this.getAccountID().getAccountPropertyInt((Object)"SERVER_PORT", 5222);
            InetSocketAddress[] addrs = null;
            try {
                addrs = NetworkUtils.getAandAAAARecords((String)serverAddressUserSetting, (int)serverPort);
            }
            catch (ParseException e) {
                logger.error((Object)"Domain not resolved", (Throwable)e);
            }
            catch (DnssecException e) {
                logger.error((Object)"DNSSEC failure for overridden server", (Throwable)e);
                this.setDnssecLoginFailure();
                return;
            }
            if (addrs == null || addrs.length == 0) {
                logger.error((Object)"No server addresses found");
                this.eventDuringLogin = null;
                this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, "No server addresses found");
            } else {
                InetSocketAddress[] inetSocketAddressArray = addrs;
                int n = addrs.length;
                int n2 = 0;
                while (n2 < n) {
                    block20: {
                        InetSocketAddress isa = inetSocketAddressArray[n2];
                        try {
                            state = this.connectAndLogin(isa, serviceName, loginStrategy);
                            if (state == ConnectState.ABORT_CONNECTING || state == ConnectState.STOP_TRYING) {
                                return;
                            }
                        }
                        catch (XMPPException ex) {
                            this.disconnectAndCleanConnection();
                            if (!this.isAuthenticationFailed(ex)) break block20;
                            throw ex;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private JabberLoginStrategy createLoginStrategy() {
        String clientCertId = this.getAccountID().getAccountPropertyString((Object)"CLIENT_TLS_CERTIFICATE");
        if (clientCertId != null) {
            return new LoginByClientCertificateStrategy(this.getAccountID());
        }
        return new LoginByPasswordStrategy(this, this.getAccountID());
    }

    private void setDnssecLoginFailure() {
        this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)this, this.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "No usable host found due to DNSSEC failures");
    }

    private ConnectState connectUsingSRVRecords(String domain, String serviceName, boolean[] dnssecState, JabberLoginStrategy loginStrategy) throws XMPPException {
        SRVRecord[] srvRecords = null;
        try {
            srvRecords = NetworkUtils.getSRVRecords((String)"xmpp-client", (String)"tcp", (String)domain);
        }
        catch (ParseException e) {
            logger.error((Object)"SRV record not resolved", (Throwable)e);
        }
        catch (DnssecException e) {
            logger.error((Object)"DNSSEC failure for SRV lookup", (Throwable)e);
            dnssecState[0] = true;
        }
        if (srvRecords != null) {
            SRVRecord[] sRVRecordArray = srvRecords;
            int n = srvRecords.length;
            int n2 = 0;
            while (n2 < n) {
                SRVRecord srv = sRVRecordArray[n2];
                InetSocketAddress[] addrs = null;
                try {
                    addrs = NetworkUtils.getAandAAAARecords((String)srv.getTarget(), (int)srv.getPort());
                }
                catch (ParseException e) {
                    logger.error((Object)"Invalid SRV record target", (Throwable)e);
                }
                catch (DnssecException e) {
                    logger.error((Object)"DNSSEC failure for A/AAAA lookup of SRV", (Throwable)e);
                    dnssecState[0] = true;
                }
                if (addrs == null || addrs.length == 0) {
                    logger.error((Object)("No A/AAAA addresses found for " + srv.getTarget()));
                } else {
                    InetSocketAddress[] inetSocketAddressArray = addrs;
                    int n3 = addrs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InetSocketAddress isa = inetSocketAddressArray[n4];
                        try {
                            if (JabberActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.protocol.jabber.REVERSE_FAILOVER_ENABLED", false)) {
                                FailoverConnectionMonitor.getInstance(this).setCurrent(domain, srv.getTarget());
                            }
                            ConnectState state = this.connectAndLogin(isa, serviceName, loginStrategy);
                            return state;
                        }
                        catch (XMPPException ex) {
                            logger.error((Object)("Error connecting to " + isa + " for domain:" + domain + " serviceName:" + serviceName), (Throwable)ex);
                            this.disconnectAndCleanConnection();
                            if (this.isAuthenticationFailed(ex)) {
                                throw ex;
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        } else {
            logger.error((Object)("No SRV addresses found for _xmpp-client._tcp." + domain));
        }
        return ConnectState.CONTINUE_TRYING;
    }

    private ConnectState connectAndLogin(InetSocketAddress currentAddress, String serviceName, JabberLoginStrategy loginStrategy) throws XMPPException {
        boolean qualifiedUserID;
        String userID = null;
        if (this.getAccountID().getProtocolDisplayName().equals("Google Talk")) {
            userID = this.getAccountID().getUserID();
            qualifiedUserID = true;
        } else {
            userID = org.jivesoftware.smack.util.StringUtils.parseName((String)this.getAccountID().getUserID());
            qualifiedUserID = false;
        }
        try {
            return this.connectAndLogin(currentAddress, serviceName, userID, this.resource, loginStrategy);
        }
        catch (XMPPException ex) {
            this.disconnectAndCleanConnection();
            if (ex.getWrappedThrowable() instanceof ConnectException || ex.getWrappedThrowable() instanceof NoRouteToHostException) {
                this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)this, this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, null);
                throw ex;
            }
            if (!qualifiedUserID) {
                try {
                    return this.connectAndLogin(currentAddress, serviceName, String.valueOf(userID) + "@" + serviceName, this.resource, loginStrategy);
                }
                catch (XMPPException ex2) {
                    this.disconnectAndCleanConnection();
                    throw ex;
                }
            }
            throw ex;
        }
    }

    private void loadResource() {
        if (this.resource == null) {
            String defaultResource = "jitsi";
            String autoGenenerateResource = this.getAccountID().getAccountPropertyString((Object)"AUTO_GENERATE_RESOURCE");
            if (autoGenenerateResource == null || Boolean.parseBoolean(autoGenenerateResource)) {
                SecureRandom random = new SecureRandom();
                this.resource = String.valueOf(defaultResource) + "-" + new BigInteger(32, random).toString(32);
            } else {
                this.resource = this.getAccountID().getAccountPropertyString((Object)"RESOURCE");
                if (this.resource == null || this.resource.length() == 0) {
                    this.resource = defaultResource;
                }
            }
        }
    }

    private void loadProxy() throws OperationFailedException {
        String globalProxyType = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyType");
        if (globalProxyType == null || globalProxyType.equals(ProxyInfo.ProxyType.NONE.name())) {
            this.proxy = ProxyInfo.forNoProxy();
        } else {
            int globalProxyPort;
            String globalProxyAddress = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyAddress");
            String globalProxyPortStr = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPort");
            try {
                globalProxyPort = Integer.parseInt(globalProxyPortStr);
            }
            catch (NumberFormatException ex) {
                throw new OperationFailedException("Wrong proxy port, " + globalProxyPortStr + " does not represent an integer", 7, (Throwable)ex);
            }
            String globalProxyUsername = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyUsername");
            String globalProxyPassword = JabberActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPassword");
            if (globalProxyAddress == null || globalProxyAddress.length() <= 0) {
                throw new OperationFailedException("Missing Proxy Address", 7);
            }
            try {
                this.proxy = new ProxyInfo(Enum.valueOf(ProxyInfo.ProxyType.class, globalProxyType), globalProxyAddress, globalProxyPort, globalProxyUsername, globalProxyPassword);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"Invalid value for smack proxy enum", (Throwable)e);
                this.proxy = null;
            }
        }
    }

    private ConnectState connectAndLogin(InetSocketAddress address, String serviceName, String userName, String resource, JabberLoginStrategy loginStrategy) throws XMPPException {
        ConnectionConfiguration confConn = new ConnectionConfiguration(address.getAddress().getHostAddress(), address.getPort(), serviceName, this.proxy);
        confConn.setReconnectionAllowed(false);
        boolean tlsRequired = loginStrategy.isTlsRequired();
        confConn.setSecurityMode(tlsRequired ? ConnectionConfiguration.SecurityMode.required : ConnectionConfiguration.SecurityMode.enabled);
        if (this.connection != null) {
            logger.error((Object)("Connection is not null and isConnected:" + this.connection.isConnected()), (Throwable)new Exception("Trace possible duplicate connections: " + this.getAccountID().getAccountAddress()));
            this.disconnectAndCleanConnection();
        }
        this.connection = new XMPPConnection(confConn);
        try {
            CertificateService cvs = this.getCertificateVerificationService();
            if (cvs != null) {
                SSLContext sslContext = loginStrategy.createSslContext(cvs, this.getTrustManager(cvs, serviceName));
                this.connection.setCustomSslContext(sslContext);
            } else if (tlsRequired) {
                throw new XMPPException("Certificate verification service is unavailable and TLS is required");
            }
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)"Error creating custom trust manager", (Throwable)e);
            throw new XMPPException("Error creating custom trust manager", (Throwable)e);
        }
        if (this.debugger == null) {
            this.debugger = new SmackPacketDebugger();
        }
        this.debugger.setConnection(this.connection);
        this.connection.addPacketListener((PacketListener)this.debugger, null);
        this.connection.addPacketInterceptor((PacketInterceptor)this.debugger, null);
        this.connection.connect();
        this.setTrafficClass();
        if (this.abortConnecting) {
            this.abortConnecting = false;
            this.disconnectAndCleanConnection();
            return ConnectState.ABORT_CONNECTING;
        }
        this.registerServiceDiscoveryManager();
        if (this.connectionListener == null) {
            this.connectionListener = new JabberConnectionListener();
        }
        if (!this.connection.isSecureConnection() && tlsRequired) {
            throw new XMPPException("TLS is required by client");
        }
        if (!this.connection.isConnected()) {
            this.disconnectAndCleanConnection();
            logger.error((Object)"Connection not established, server not found!");
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, null);
            return ConnectState.ABORT_CONNECTING;
        }
        this.connection.addConnectionListener((ConnectionListener)this.connectionListener);
        if (this.abortConnecting) {
            this.abortConnecting = false;
            this.disconnectAndCleanConnection();
            return ConnectState.ABORT_CONNECTING;
        }
        this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.REGISTERING, -1, null);
        if (!loginStrategy.login(this.connection, userName, resource)) {
            this.disconnectAndCleanConnection();
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 1, String.valueOf(loginStrategy.getClass().getName()) + " requests abort");
            return ConnectState.ABORT_CONNECTING;
        }
        if (this.connection.isAuthenticated()) {
            this.eventDuringLogin = null;
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.REGISTERED, -1, null);
            OperationSetPersistentPresenceJabberImpl opSet = (OperationSetPersistentPresenceJabberImpl)this.getOperationSet(OperationSetPersistentPresence.class);
            try {
                opSet.publishPresenceStatus((PresenceStatus)this.getJabberStatusEnum().getStatus("Available"), "");
            }
            catch (Exception e) {
                logger.error((Object)"Failed to publish presence status");
            }
            return ConnectState.STOP_TRYING;
        }
        this.disconnectAndCleanConnection();
        this.eventDuringLogin = null;
        this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.UNREGISTERED, -1, null);
        return ConnectState.CONTINUE_TRYING;
    }

    private X509TrustManager getTrustManager(CertificateService cvs, String serviceName) throws GeneralSecurityException {
        return new HostTrustManager(cvs.getTrustManager(Arrays.asList(serviceName, "_xmpp-client." + serviceName)));
    }

    private void registerServiceDiscoveryManager() {
        String name = String.valueOf(System.getProperty("sip-communicator.application.name", "SIP Communicator ")) + System.getProperty("sip-communicator.version", "SVN");
        ServiceDiscoveryManager.setIdentityName((String)name);
        ServiceDiscoveryManager.setIdentityType((String)"pc");
        this.discoveryManager = new ScServiceDiscoveryManager(this, new String[]{"http://jabber.org/protocol/commands"}, this.supportedFeatures.toArray(new String[this.supportedFeatures.size()]));
        boolean isCallingDisabled = JabberActivator.getConfigurationService().getBoolean(IS_CALLING_DISABLED, false);
        boolean isCallingDisabledForAccount = false;
        if (this.accountID != null && this.accountID.getAccountPropertyBoolean((Object)"CALLING_DISABLED", false)) {
            isCallingDisabled = true;
        }
        if (this.isGTalkTesting() && !isCallingDisabled && !isCallingDisabledForAccount) {
            this.discoveryManager.addExtFeature(CAPS_GTALK_WEB_VOICE);
            this.discoveryManager.addExtFeature(CAPS_GTALK_WEB_VIDEO);
            this.discoveryManager.addExtFeature(CAPS_GTALK_WEB_CAMERA);
            this.discoveryManager.addFeature(URN_GOOGLE_VOICE);
            this.discoveryManager.addFeature(URN_GOOGLE_VIDEO);
            this.discoveryManager.addFeature(URN_GOOGLE_CAMERA);
        }
        if (this.opsetContactCapabilities != null) {
            this.opsetContactCapabilities.setDiscoveryManager(this.discoveryManager);
        }
    }

    public void disconnectAndCleanConnection() {
        if (this.connection != null) {
            this.connection.removeConnectionListener((ConnectionListener)this.connectionListener);
            try {
                OperationSetPersistentPresenceJabberImpl opSet = (OperationSetPersistentPresenceJabberImpl)this.getOperationSet(OperationSetPersistentPresence.class);
                Presence unavailablePresence = new Presence(Presence.Type.unavailable);
                if (opSet != null && !StringUtils.isNullOrEmpty((String)opSet.getCurrentStatusMessage())) {
                    unavailablePresence.setStatus(opSet.getCurrentStatusMessage());
                }
                this.connection.disconnect(unavailablePresence);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connectionListener = null;
            this.connection = null;
            try {
                if (this.opsetContactCapabilities != null) {
                    this.opsetContactCapabilities.setDiscoveryManager(null);
                }
            }
            finally {
                if (this.discoveryManager != null) {
                    this.discoveryManager.stop();
                    this.discoveryManager = null;
                }
            }
        }
    }

    public void unregister() {
        this.unregister(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(boolean fireEvent) {
        Object object = this.initializationLock;
        synchronized (object) {
            if (fireEvent) {
                this.eventDuringLogin = null;
                this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.UNREGISTERING, -1, null);
            }
            this.disconnectAndCleanConnection();
            RegistrationState currRegState = this.getRegistrationState();
            if (fireEvent) {
                this.eventDuringLogin = null;
                this.fireRegistrationStateChanged(currRegState, RegistrationState.UNREGISTERED, 0, null);
            }
        }
    }

    public String getProtocolName() {
        return "Jabber";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(String screenname, AccountID accountID) {
        Object object = this.initializationLock;
        synchronized (object) {
            this.accountID = accountID;
            this.supportedFeatures.clear();
            this.clearRegistrationStateChangeListener();
            this.clearSupportedOperationSet();
            Object object2 = providerCreationLock;
            synchronized (object2) {
                block21: {
                    if (providerManager == null) {
                        try {
                            try {
                                ProviderManager.setInstance((ProviderManager)new ProviderManagerExt());
                            }
                            catch (Throwable throwable) {
                                providerManager = ProviderManager.getInstance();
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            providerManager = ProviderManager.getInstance();
                            throw throwable;
                        }
                        providerManager = ProviderManager.getInstance();
                    }
                }
            }
            String protocolIconPath = accountID.getAccountPropertyString((Object)"PROTOCOL_ICON_PATH");
            if (protocolIconPath == null) {
                protocolIconPath = "resources/images/protocol/jabber";
            }
            this.jabberIcon = new ProtocolIconJabberImpl(protocolIconPath);
            this.jabberStatusEnum = JabberStatusEnum.getJabberStatusEnum((String)protocolIconPath);
            this.supportedFeatures.add("http://jabber.org/protocol/disco#info");
            String keepAliveStrValue = accountID.getAccountPropertyString((Object)"KEEP_ALIVE_METHOD");
            InfoRetreiver infoRetreiver = new InfoRetreiver(this, screenname);
            OperationSetPersistentPresenceJabberImpl persistentPresence = new OperationSetPersistentPresenceJabberImpl(this, infoRetreiver);
            this.addSupportedOperationSet(OperationSetPersistentPresence.class, (OperationSet)persistentPresence);
            this.addSupportedOperationSet(OperationSetPresence.class, (OperationSet)persistentPresence);
            if (accountID.getAccountPropertyString((Object)"READ_ONLY_GROUPS") != null) {
                this.addSupportedOperationSet(OperationSetPersistentPresencePermissions.class, (OperationSet)new OperationSetPersistentPresencePermissionsJabberImpl(this));
            }
            OperationSetBasicInstantMessagingJabberImpl basicInstantMessaging = new OperationSetBasicInstantMessagingJabberImpl(this);
            if ((keepAliveStrValue == null || keepAliveStrValue.equalsIgnoreCase("XEP-0199")) && this.keepAliveManager == null) {
                this.keepAliveManager = new KeepAliveManager(this);
            }
            this.addSupportedOperationSet(OperationSetBasicInstantMessaging.class, (OperationSet)basicInstantMessaging);
            this.addSupportedOperationSet(OperationSetExtendedAuthorizations.class, (OperationSet)new OperationSetExtendedAuthorizationsJabberImpl(this, persistentPresence));
            this.addSupportedOperationSet(OperationSetWhiteboarding.class, (OperationSet)new OperationSetWhiteboardingJabberImpl(this));
            this.addSupportedOperationSet(OperationSetTypingNotifications.class, (OperationSet)new OperationSetTypingNotificationsJabberImpl(this));
            this.addSupportedOperationSet(OperationSetMultiUserChat.class, (OperationSet)new OperationSetMultiUserChatJabberImpl(this));
            this.addSupportedOperationSet(OperationSetServerStoredContactInfo.class, (OperationSet)new OperationSetServerStoredContactInfoJabberImpl(infoRetreiver));
            OperationSetServerStoredAccountInfoJabberImpl accountInfo = new OperationSetServerStoredAccountInfoJabberImpl(this, infoRetreiver, screenname);
            this.addSupportedOperationSet(OperationSetServerStoredAccountInfo.class, (OperationSet)accountInfo);
            this.addSupportedOperationSet(OperationSetAvatar.class, (OperationSet)new OperationSetAvatarJabberImpl(this, (OperationSetServerStoredAccountInfo)accountInfo));
            this.addSupportedOperationSet(OperationSetFileTransfer.class, (OperationSet)new OperationSetFileTransferJabberImpl(this));
            this.addSupportedOperationSet(OperationSetInstantMessageTransform.class, (OperationSet)new OperationSetInstantMessageTransformImpl());
            this.supportedFeatures.add("urn:xmpp:thumbs:0");
            this.supportedFeatures.add("urn:xmpp:bob");
            this.addSupportedOperationSet(OperationSetThumbnailedFileFactory.class, (OperationSet)new OperationSetThumbnailedFileFactoryImpl());
            this.supportedFeatures.add("http://jabber.org/protocol/muc#rooms");
            this.supportedFeatures.add("http://jabber.org/protocol/muc#traffic");
            this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_HDREXT);
            providerManager.addIQProvider("jingle", URN_XMPP_JINGLE, (Object)new JingleIQProvider());
            providerManager.addIQProvider("inputevt", "http://jitsi.org/protocol/inputevt", (Object)new InputEvtIQProvider());
            providerManager.addIQProvider("conference-info", "urn:ietf:params:xml:ns:conference-info", (Object)new CoinIQProvider());
            this.supportedFeatures.add(URN_XMPP_JINGLE_COIN);
            providerManager.addIQProvider("query", "google:jingleinfo", (Object)new JingleInfoQueryIQProvider());
            providerManager.addIQProvider("conference", "http://jitsi.org/protocol/colibri", (Object)new ColibriIQProvider());
            providerManager.addExtensionProvider("conference", "http://jitsi.org/protocol/condesc", (Object)new ConferenceDescriptionPacketExtension.Provider());
            providerManager.addExtensionProvider("received", "urn:xmpp:carbons:2", (Object)new CarbonPacketExtension.Provider("received"));
            providerManager.addExtensionProvider("sent", "urn:xmpp:carbons:2", (Object)new CarbonPacketExtension.Provider("sent"));
            boolean isCallingDisabled = JabberActivator.getConfigurationService().getBoolean(IS_CALLING_DISABLED, false);
            boolean isCallingDisabledForAccount = accountID.getAccountPropertyBoolean((Object)"CALLING_DISABLED", false);
            if (!isCallingDisabled && !isCallingDisabledForAccount) {
                OperationSetBasicTelephonyJabberImpl basicTelephony = new OperationSetBasicTelephonyJabberImpl(this);
                this.addSupportedOperationSet(OperationSetAdvancedTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetBasicTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetSecureZrtpTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetSecureSDesTelephony.class, (OperationSet)basicTelephony);
                this.addSupportedOperationSet(OperationSetVideoTelephony.class, (OperationSet)new OperationSetVideoTelephonyJabberImpl(basicTelephony));
                this.addSupportedOperationSet(OperationSetTelephonyConferencing.class, (OperationSet)new OperationSetTelephonyConferencingJabberImpl(this));
                this.addSupportedOperationSet(OperationSetBasicAutoAnswer.class, (OperationSet)new OperationSetAutoAnswerJabberImpl(this));
                this.addSupportedOperationSet(OperationSetResourceAwareTelephony.class, (OperationSet)new OperationSetResAwareTelephonyJabberImpl(basicTelephony));
                boolean isVideobridgeDisabled = JabberActivator.getConfigurationService().getBoolean("net.java.sip.communicator.service.protocol.VIDEO_BRIDGE_DISABLED", false);
                if (!isVideobridgeDisabled) {
                    this.addSupportedOperationSet(OperationSetVideoBridge.class, (OperationSet)new OperationSetVideoBridgeImpl(this));
                }
                OperationSetDTMFJabberImpl operationSetDTMFSip = new OperationSetDTMFJabberImpl(this);
                this.addSupportedOperationSet(OperationSetDTMF.class, (OperationSet)operationSetDTMFSip);
                this.addJingleFeatures();
                boolean isDesktopStreamingDisabled = JabberActivator.getConfigurationService().getBoolean(IS_DESKTOP_STREAMING_DISABLED, false);
                boolean isAccountDesktopStreamingDisabled = accountID.getAccountPropertyBoolean((Object)"DESKTOP_STREAMING_DISABLED", false);
                if (!isDesktopStreamingDisabled && !isAccountDesktopStreamingDisabled) {
                    this.addSupportedOperationSet(OperationSetDesktopStreaming.class, (OperationSet)new OperationSetDesktopStreamingJabberImpl(basicTelephony));
                    this.addSupportedOperationSet(OperationSetDesktopSharingServer.class, (OperationSet)new OperationSetDesktopSharingServerJabberImpl(basicTelephony));
                    this.supportedFeatures.add("http://jitsi.org/protocol/inputevt/sharer");
                    this.addSupportedOperationSet(OperationSetDesktopSharingClient.class, (OperationSet)new OperationSetDesktopSharingClientJabberImpl(this));
                    this.supportedFeatures.add("http://jitsi.org/protocol/inputevt/sharee");
                }
            }
            this.opsetContactCapabilities = new OperationSetContactCapabilitiesJabberImpl(this);
            if (this.discoveryManager != null) {
                this.opsetContactCapabilities.setDiscoveryManager(this.discoveryManager);
            }
            this.addSupportedOperationSet(OperationSetContactCapabilities.class, (OperationSet)this.opsetContactCapabilities);
            this.addSupportedOperationSet(OperationSetGenericNotifications.class, (OperationSet)new OperationSetGenericNotificationsJabberImpl(this));
            this.supportedFeatures.add("jabber:iq:version");
            if (this.versionManager == null) {
                this.versionManager = new VersionManager(this);
            }
            this.supportedFeatures.add("urn:xmpp:message-correct:0");
            this.addSupportedOperationSet(OperationSetMessageCorrection.class, (OperationSet)basicInstantMessaging);
            OperationSetChangePasswordJabberImpl opsetChangePassword = new OperationSetChangePasswordJabberImpl(this);
            this.addSupportedOperationSet(OperationSetChangePassword.class, (OperationSet)opsetChangePassword);
            OperationSetCusaxUtilsJabberImpl opsetCusaxCusaxUtils = new OperationSetCusaxUtilsJabberImpl(this);
            this.addSupportedOperationSet(OperationSetCusaxUtils.class, (OperationSet)opsetCusaxCusaxUtils);
            boolean isUserSearchEnabled = accountID.getAccountPropertyBoolean((Object)IS_USER_SEARCH_ENABLED_PROPERTY, false);
            if (isUserSearchEnabled) {
                this.addSupportedOperationSet(OperationSetUserSearch.class, (OperationSet)new OperationSetUserSearchJabberImpl(this));
            }
            this.isInitialized = true;
        }
    }

    private void addJingleFeatures() {
        this.supportedFeatures.add(URN_XMPP_JINGLE);
        this.supportedFeatures.add(URN_XMPP_JINGLE_RTP);
        this.supportedFeatures.add(URN_XMPP_JINGLE_RAW_UDP_0);
        if (this.accountID.getAccountPropertyBoolean((Object)"ICE_ENABLED", true)) {
            this.supportedFeatures.add(URN_XMPP_JINGLE_ICE_UDP_1);
        }
        this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_AUDIO);
        this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_VIDEO);
        this.supportedFeatures.add(URN_XMPP_JINGLE_RTP_ZRTP);
        if (this.accountID.getAccountPropertyBoolean((Object)"JINGLE_NODES_ENABLED", true)) {
            this.supportedFeatures.add(URN_XMPP_JINGLE_NODES);
        }
        this.supportedFeatures.add(URN_XMPP_JINGLE_TRANSFER_0);
        if (this.accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && this.accountID.isEncryptionProtocolEnabled(DtlsControl.PROTO_NAME)) {
            this.supportedFeatures.add(URN_XMPP_JINGLE_DTLS_SRTP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.initializationLock;
        synchronized (object) {
            OperationSetBasicTelephonyJabberImpl telephony;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Killing the Jabber Protocol Provider.");
            }
            if ((telephony = (OperationSetBasicTelephonyJabberImpl)this.getOperationSet(OperationSetBasicTelephony.class)) != null) {
                telephony.shutdown();
            }
            this.disconnectAndCleanConnection();
            this.isInitialized = false;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public AccountID getAccountID() {
        return this.accountID;
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    private boolean isAuthenticationFailed(XMPPException ex) {
        String exMsg = ex.getMessage().toLowerCase();
        return exMsg.indexOf("sasl authentication") != -1 && exMsg.indexOf("failed") != -1 || exMsg.indexOf("does not support compatible authentication mechanism") != -1 || exMsg.indexOf("unable to determine password") != -1;
    }

    private void fireRegistrationStateChanged(XMPPException ex) {
        int reason = -1;
        RegistrationState regState = RegistrationState.UNREGISTERED;
        String reasonStr = null;
        Throwable wrappedEx = ex.getWrappedThrowable();
        if (wrappedEx != null && (wrappedEx instanceof UnknownHostException || wrappedEx instanceof ConnectException || wrappedEx instanceof SocketException)) {
            reason = 8;
            regState = RegistrationState.CONNECTION_FAILED;
        } else {
            String exMsg = ex.getMessage().toLowerCase();
            if (this.isAuthenticationFailed(ex)) {
                JabberActivator.getProtocolProviderFactory().storePassword(this.getAccountID(), null);
                reason = 1;
                regState = RegistrationState.AUTHENTICATION_FAILED;
                this.fireRegistrationStateChanged(this.getRegistrationState(), regState, reason, null);
                this.reregister(1);
                return;
            }
            if (exMsg.indexOf("no response from the server") != -1 || exMsg.indexOf("connection failed") != -1) {
                reason = -1;
                regState = RegistrationState.CONNECTION_FAILED;
            } else if (exMsg.indexOf("tls is required") != -1) {
                regState = RegistrationState.AUTHENTICATION_FAILED;
                reason = 9;
            }
        }
        if (regState == RegistrationState.UNREGISTERED || regState == RegistrationState.CONNECTION_FAILED) {
            this.disconnectAndCleanConnection();
        }
        this.fireRegistrationStateChanged(this.getRegistrationState(), regState, reason, reasonStr);
    }

    public ProtocolIcon getProtocolIcon() {
        return this.jabberIcon;
    }

    JabberStatusEnum getJabberStatusEnum() {
        return this.jabberStatusEnum;
    }

    public boolean isExtFeatureListSupported(String jid, String ... extFeatures) {
        EntityCapsManager capsManager = this.discoveryManager.getCapsManager();
        EntityCapsManager.Caps caps = capsManager.getCapsByUser(jid);
        String bypassDomain = this.accountID.getAccountPropertyString((Object)"TELEPHONY_BYPASS_GTALK_CAPS");
        String domain = org.jivesoftware.smack.util.StringUtils.parseServer((String)jid);
        boolean domainEquals = domain.equals(bypassDomain);
        if (caps != null && caps.ext != null) {
            String[] exts = caps.ext.split(" ");
            boolean found = false;
            String[] stringArray = extFeatures;
            int n = extFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                String extFeature = stringArray[n2];
                if (extFeature.equals(CAPS_GTALK_WEB_VOICE) && domainEquals) {
                    return true;
                }
                found = false;
                String[] stringArray2 = exts;
                int n3 = exts.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ext = stringArray2[n4];
                    if (ext.equals(extFeature)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) break;
                ++n2;
            }
            return found;
        }
        return false;
    }

    public boolean isFeatureListSupported(String jid, String ... features) {
        boolean isFeatureListSupported;
        block6: {
            isFeatureListSupported = true;
            try {
                if (this.discoveryManager == null) {
                    return isFeatureListSupported;
                }
                DiscoverInfo featureInfo = this.discoveryManager.discoverInfoNonBlocking(jid);
                if (featureInfo == null) {
                    return isFeatureListSupported;
                }
                String[] stringArray = features;
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    String feature = stringArray[n2];
                    if (!featureInfo.containsFeature(feature)) {
                        isFeatureListSupported = false;
                        break;
                    }
                    ++n2;
                }
            }
            catch (XMPPException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)"Failed to retrive discovery info.", (Throwable)e);
            }
        }
        return isFeatureListSupported;
    }

    public boolean isFeatureSupported(String jid, String feature) {
        return this.isFeatureListSupported(jid, feature);
    }

    public String getFullJid(Contact contact) {
        return this.getFullJid(contact.getAddress());
    }

    public String getFullJid(String bareJid) {
        Roster roster;
        XMPPConnection connection = this.getConnection();
        if (connection != null && connection.isConnected() && (roster = connection.getRoster()) != null) {
            return roster.getPresence(bareJid).getFrom();
        }
        return null;
    }

    public ScServiceDiscoveryManager getDiscoveryManager() {
        return this.discoveryManager;
    }

    public String getOurJID() {
        String jid = null;
        if (this.connection != null) {
            jid = this.connection.getUser();
        }
        if (jid == null) {
            String accountIDUserID = this.getAccountID().getUserID();
            String userID = org.jivesoftware.smack.util.StringUtils.parseName((String)accountIDUserID);
            String serviceName = org.jivesoftware.smack.util.StringUtils.parseServer((String)accountIDUserID);
            jid = String.valueOf(userID) + "@" + serviceName;
        }
        return jid;
    }

    public InetAddress getNextHop() throws IllegalArgumentException {
        InetAddress nextHop = null;
        String nextHopStr = null;
        nextHopStr = this.proxy != null && this.proxy.getProxyType() != ProxyInfo.ProxyType.NONE ? this.proxy.getProxyAddress() : this.getConnection().getHost();
        try {
            nextHop = NetworkUtils.getInetAddress((String)nextHopStr);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("seems we don't have a valid next hop.", ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning address " + nextHop + " as next hop."));
        }
        return nextHop;
    }

    public void startJingleNodesDiscovery() {
        JabberAccountIDImpl accID = (JabberAccountIDImpl)this.getAccountID();
        SmackServiceNode service = new SmackServiceNode(this.connection, 60000L);
        this.connection.addConnectionListener((ConnectionListener)service);
        for (JingleNodeDescriptor desc : accID.getJingleNodes()) {
            TrackerEntry entry = new TrackerEntry(desc.isRelaySupported() ? TrackerEntry.Type.relay : TrackerEntry.Type.tracker, TrackerEntry.Policy._public, desc.getJID(), "udp");
            service.addTrackerEntry(entry);
        }
        new Thread(new JingleNodesServiceDiscovery(service, this.connection, accID, this.jingleNodesSyncRoot)).start();
        this.jingleNodesServiceNode = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmackServiceNode getJingleNodesServiceNode() {
        Object object = this.jingleNodesSyncRoot;
        synchronized (object) {
            return this.jingleNodesServiceNode;
        }
    }

    public static void throwOperationFailedException(String message, int errorCode, Throwable cause, Logger logger) throws OperationFailedException {
        logger.error((Object)message, cause);
        if (cause == null) {
            throw new OperationFailedException(message, errorCode);
        }
        throw new OperationFailedException(message, errorCode, cause);
    }

    public SecurityAuthority getAuthority() {
        return this.authority;
    }

    public boolean isGTalkTesting() {
        return Boolean.getBoolean("gtalktesting") || JabberActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.protocol.jabber.gtalktesting", false) || this.accountID.getAccountPropertyBoolean((Object)"GTALK_ICE_ENABLED", true);
    }

    UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    public boolean isGmailOrGoogleAppsAccount() {
        String domain = org.jivesoftware.smack.util.StringUtils.parseServer((String)this.getAccountID().getUserID());
        return ProtocolProviderServiceJabberImpl.isGmailOrGoogleAppsAccount(domain);
    }

    public static boolean isGmailOrGoogleAppsAccount(String domain) {
        SRVRecord[] srvRecords = null;
        try {
            srvRecords = NetworkUtils.getSRVRecords((String)"xmpp-client", (String)"tcp", (String)domain);
        }
        catch (ParseException e) {
            logger.info((Object)"Failed to get SRV records for XMPP domain");
            return false;
        }
        catch (DnssecException e) {
            logger.error((Object)"DNSSEC failure while checking for google domains", (Throwable)e);
            return false;
        }
        if (srvRecords == null) {
            return false;
        }
        SRVRecord[] sRVRecordArray = srvRecords;
        int n = srvRecords.length;
        int n2 = 0;
        while (n2 < n) {
            SRVRecord srv = sRVRecordArray[n2];
            if (srv.getTarget().endsWith("google.com") || srv.getTarget().endsWith("google.com.")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setTrafficClass() {
        ConfigurationService configService;
        String dscp;
        Socket s = this.connection.getSocket();
        if (s != null && (dscp = (configService = JabberActivator.getConfigurationService()).getString(XMPP_DSCP_PROPERTY)) != null) {
            try {
                int dscpInt = Integer.parseInt(dscp) << 2;
                if (dscpInt > 0) {
                    s.setTrafficClass(dscpInt);
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to set trafficClass", (Throwable)e);
            }
        }
    }

    public String getJitsiVideobridge() {
        XMPPConnection connection = this.getConnection();
        if (connection != null) {
            DiscoverItems discoverItems;
            ScServiceDiscoveryManager discoveryManager;
            block7: {
                discoveryManager = this.getDiscoveryManager();
                String serviceName = connection.getServiceName();
                discoverItems = null;
                try {
                    discoverItems = discoveryManager.discoverItems(serviceName);
                }
                catch (XMPPException xmppe) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug((Object)("Failed to discover the items associated with Jabber entity: " + serviceName), (Throwable)xmppe);
                }
            }
            if (discoverItems != null) {
                Iterator discoverItemIter = discoverItems.getItems();
                while (discoverItemIter.hasNext()) {
                    DiscoverItems.Item discoverItem = (DiscoverItems.Item)discoverItemIter.next();
                    String entityID = discoverItem.getEntityID();
                    DiscoverInfo discoverInfo = null;
                    try {
                        discoverInfo = discoveryManager.discoverInfo(entityID);
                    }
                    catch (XMPPException xmppe) {
                        logger.warn((Object)("Failed to discover information about Jabber entity: " + entityID), (Throwable)xmppe);
                    }
                    if (discoverInfo == null || !discoverInfo.containsFeature("http://jitsi.org/protocol/colibri")) continue;
                    return entityID;
                }
            }
        }
        return null;
    }

    private static void loadJabberServiceClasses() {
        if (!OSUtils.IS_ANDROID) {
            return;
        }
        try {
            SmackConfiguration.getVersion();
            Class.forName(ServiceDiscoveryManager.class.getName());
            Class.forName(DelayInformation.class.getName());
            Class.forName(DelayInformationProvider.class.getName());
            Class.forName(Socks5BytestreamManager.class.getName());
            Class.forName(XHTMLManager.class.getName());
            Class.forName(InBandBytestreamManager.class.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Error loading classes in smack", (Throwable)e);
        }
    }

    static enum ConnectState {
        ABORT_CONNECTING,
        CONTINUE_TRYING,
        STOP_TRYING;

    }

    private class HostTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;

        HostTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            ProtocolProviderServiceJabberImpl.this.abortConnecting = true;
            try {
                this.tm.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "Not trusted certificate");
                    }
                }).start();
                throw e;
            }
            if (ProtocolProviderServiceJabberImpl.this.abortConnecting) {
                ProtocolProviderServiceJabberImpl.this.abortConnecting = false;
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ProtocolProviderServiceJabberImpl.this.reregister(3);
                }
            }).start();
        }
    }

    private class JabberConnectionListener
    implements ConnectionListener {
        private JabberConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed() {
            Object object = ProtocolProviderServiceJabberImpl.this.connectAndLoginLock;
            synchronized (object) {
                if (ProtocolProviderServiceJabberImpl.this.inConnectAndLogin) {
                    ProtocolProviderServiceJabberImpl.this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)ProtocolProviderServiceJabberImpl.this, ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, -1, null);
                    return;
                }
            }
            ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, -1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosedOnError(Exception exception) {
            logger.error((Object)("connectionClosedOnError " + exception.getLocalizedMessage()));
            if (exception instanceof XMPPException) {
                StreamError err = ((XMPPException)((Object)exception)).getStreamError();
                if (err != null && err.getCode().equals(XMPPError.Condition.conflict.toString())) {
                    Object object = ProtocolProviderServiceJabberImpl.this.connectAndLoginLock;
                    synchronized (object) {
                        if (ProtocolProviderServiceJabberImpl.this.inConnectAndLogin) {
                            ProtocolProviderServiceJabberImpl.this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)ProtocolProviderServiceJabberImpl.this, ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.UNREGISTERED, 2, "Connecting multiple times with the same resource");
                            return;
                        }
                    }
                    ProtocolProviderServiceJabberImpl.this.disconnectAndCleanConnection();
                    ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.UNREGISTERED, 2, "Connecting multiple times with the same resource");
                    return;
                }
            } else if (exception instanceof SSLHandshakeException && exception.getCause() instanceof CertificateException) {
                return;
            }
            Object object = ProtocolProviderServiceJabberImpl.this.connectAndLoginLock;
            synchronized (object) {
                if (ProtocolProviderServiceJabberImpl.this.inConnectAndLogin) {
                    ProtocolProviderServiceJabberImpl.this.eventDuringLogin = new RegistrationStateChangeEvent((ProtocolProviderService)ProtocolProviderServiceJabberImpl.this, ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, -1, exception.getMessage());
                    return;
                }
            }
            ProtocolProviderServiceJabberImpl.this.disconnectAndCleanConnection();
            ProtocolProviderServiceJabberImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceJabberImpl.this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, -1, exception.getMessage());
        }

        public void reconnectingIn(int i) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("reconnectingIn " + i));
            }
        }

        public void reconnectionSuccessful() {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"reconnectionSuccessful");
            }
        }

        public void reconnectionFailed(Exception exception) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"reconnectionFailed ", (Throwable)exception);
            }
        }
    }
}

