/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import java.nio.ByteOrder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.HeapChannelBuffer;
import org.jboss.netty.buffer.HeapChannelBufferFactory;

public class LittleEndianHeapChannelBuffer
extends HeapChannelBuffer {
    public LittleEndianHeapChannelBuffer(int length) {
        super(length);
    }

    public LittleEndianHeapChannelBuffer(byte[] array) {
        super(array);
    }

    private LittleEndianHeapChannelBuffer(byte[] array, int readerIndex, int writerIndex) {
        super(array, readerIndex, writerIndex);
    }

    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public short getShort(int index) {
        return (short)(this.array[index] & 0xFF | this.array[index + 1] << 8);
    }

    public int getUnsignedMedium(int index) {
        return (this.array[index] & 0xFF) << 0 | (this.array[index + 1] & 0xFF) << 8 | (this.array[index + 2] & 0xFF) << 16;
    }

    public int getInt(int index) {
        return (this.array[index] & 0xFF) << 0 | (this.array[index + 1] & 0xFF) << 8 | (this.array[index + 2] & 0xFF) << 16 | (this.array[index + 3] & 0xFF) << 24;
    }

    public long getLong(int index) {
        return ((long)this.array[index] & 0xFFL) << 0 | ((long)this.array[index + 1] & 0xFFL) << 8 | ((long)this.array[index + 2] & 0xFFL) << 16 | ((long)this.array[index + 3] & 0xFFL) << 24 | ((long)this.array[index + 4] & 0xFFL) << 32 | ((long)this.array[index + 5] & 0xFFL) << 40 | ((long)this.array[index + 6] & 0xFFL) << 48 | ((long)this.array[index + 7] & 0xFFL) << 56;
    }

    public void setShort(int index, int value) {
        this.array[index] = (byte)(value >>> 0);
        this.array[index + 1] = (byte)(value >>> 8);
    }

    public void setMedium(int index, int value) {
        this.array[index] = (byte)(value >>> 0);
        this.array[index + 1] = (byte)(value >>> 8);
        this.array[index + 2] = (byte)(value >>> 16);
    }

    public void setInt(int index, int value) {
        this.array[index] = (byte)(value >>> 0);
        this.array[index + 1] = (byte)(value >>> 8);
        this.array[index + 2] = (byte)(value >>> 16);
        this.array[index + 3] = (byte)(value >>> 24);
    }

    public void setLong(int index, long value) {
        this.array[index] = (byte)(value >>> 0);
        this.array[index + 1] = (byte)(value >>> 8);
        this.array[index + 2] = (byte)(value >>> 16);
        this.array[index + 3] = (byte)(value >>> 24);
        this.array[index + 4] = (byte)(value >>> 32);
        this.array[index + 5] = (byte)(value >>> 40);
        this.array[index + 6] = (byte)(value >>> 48);
        this.array[index + 7] = (byte)(value >>> 56);
    }

    public ChannelBuffer duplicate() {
        return new LittleEndianHeapChannelBuffer(this.array, this.readerIndex(), this.writerIndex());
    }

    public ChannelBuffer copy(int index, int length) {
        if (index < 0 || length < 0 || index + length > this.array.length) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Need " + (index + length) + ", maximum is " + this.array.length);
        }
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.array, index, copiedArray, 0, length);
        return new LittleEndianHeapChannelBuffer(copiedArray);
    }
}

