/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.icbm.SingleBuddyRequest;
import net.kano.joscar.snaccmd.icon.IconCommand;

public class IconRequest
extends IconCommand
implements SingleBuddyRequest {
    private static final Logger LOGGER = Logger.getLogger(IconRequest.class.getName());
    public static final int CODE_DEFAULT = 1;
    private final String sn;
    private final int code;
    private final ExtraInfoData iconInfo;

    protected IconRequest(SnacPacket packet) {
        super(4);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        StringBlock snInfo = OscarTools.readScreenname(snacData);
        this.sn = snInfo.getString();
        ByteBlock rest = snacData.subBlock(snInfo.getTotalSize());
        this.code = BinaryTools.getUByte((ByteBlock)rest, (int)0);
        ByteBlock iconBlock = rest.subBlock(1);
        ExtraInfoBlock block = ExtraInfoBlock.readExtraInfoBlock(iconBlock);
        if (block.getType() != 1) {
            this.iconInfo = block.getExtraData();
        } else {
            LOGGER.warning("Got strange icon block code in icon request: " + block);
            this.iconInfo = null;
        }
    }

    public IconRequest(String sn, ExtraInfoData iconInfo) {
        this(sn, 1, iconInfo);
    }

    public IconRequest(String sn, int code, ExtraInfoData iconInfo) {
        super(4);
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        DefensiveTools.checkRange((int)code, (String)"code", (int)0);
        DefensiveTools.checkNull((Object)iconInfo, (String)"iconInfo");
        this.sn = sn;
        this.code = code;
        this.iconInfo = iconInfo;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getCode() {
        return this.code;
    }

    public final ExtraInfoData getIconInfo() {
        return this.iconInfo;
    }

    public void writeData(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.sn);
        BinaryTools.writeUByte((OutputStream)out, (int)this.code);
        new ExtraInfoBlock(1, this.iconInfo).write(out);
    }

    public String toString() {
        return "IconRequest for " + this.sn + " (code=" + this.code + "): iconInfo=<" + this.iconInfo + ">";
    }
}

