/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.packet.http.HttpResponse;

public abstract class HttpRequest {
    public static final String WINDOW_ENCODING = "windows-1250";
    protected final IGGConfiguration m_ggconfiguration;
    protected final HttpURLConnection m_huc;

    protected HttpRequest(IGGConfiguration configuration) throws IOException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this.m_ggconfiguration = configuration;
        URL url = new URL(this.getURL());
        this.m_huc = (HttpURLConnection)url.openConnection();
        this.m_huc.setRequestMethod("POST");
        this.m_huc.setDoInput(true);
        if (this.wannaWrite()) {
            this.m_huc.setDoOutput(true);
        }
        this.m_huc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.m_huc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)");
    }

    public HttpURLConnection connect() throws IOException {
        this.m_huc.setRequestProperty("Content-Length", String.valueOf(this.getRequestBody().length()));
        this.m_huc.connect();
        return this.m_huc;
    }

    public HttpURLConnection sendRequest() throws IOException {
        if (this.wannaWrite()) {
            PrintWriter out = new PrintWriter(this.m_huc.getOutputStream(), true);
            out.println(this.getRequestBody());
            out.close();
        }
        return this.m_huc;
    }

    public HttpURLConnection disconnect() {
        if (this.m_huc == null) {
            throw new IllegalStateException("must call connect() and sendRequest() first");
        }
        this.m_huc.disconnect();
        return this.m_huc;
    }

    public abstract HttpResponse getResponse() throws IOException;

    protected abstract String getURL();

    protected abstract String getRequestBody() throws UnsupportedEncodingException;

    protected abstract boolean wannaWrite();
}

