/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.instance.Node;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Document;

public final class VersionCheck {
    private static final int TIMEOUT = 1000;
    private static final int A_INTERVAL = 5;
    private static final int B_INTERVAL = 10;
    private static final int C_INTERVAL = 20;
    private static final int D_INTERVAL = 40;
    private static final int E_INTERVAL = 60;
    private static final int F_INTERVAL = 100;
    private static final int G_INTERVAL = 150;
    private static final int H_INTERVAL = 300;
    private static final int J_INTERVAL = 600;
    private MessageDigest md;

    public VersionCheck() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    public void check(final Node hazelcastNode, final String version, final boolean isEnterprise) {
        if (!hazelcastNode.getGroupProperties().VERSION_CHECK_ENABLED.getBoolean()) {
            return;
        }
        hazelcastNode.nodeEngine.getExecutionService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                VersionCheck.this.doCheck(hazelcastNode, version, isEnterprise);
            }
        }, 0L, 1L, TimeUnit.DAYS);
    }

    public void shutdown() {
    }

    private String convertToLetter(int size) {
        String letter = size < 5 ? "A" : (size < 10 ? "B" : (size < 20 ? "C" : (size < 40 ? "D" : (size < 60 ? "E" : (size < 100 ? "F" : (size < 150 ? "G" : (size < 300 ? "H" : (size < 600 ? "J" : "I"))))))));
        return letter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheck(Node hazelcastNode, String version, boolean isEnterprise) {
        InputStream is;
        String downloadId;
        block4: {
            downloadId = "source";
            is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("hazelcast-download.properties");
                if (is == null) break block4;
                Properties properties = new Properties();
                properties.load(is);
                downloadId = properties.getProperty("hazelcastDownloadId");
            }
            catch (IOException ignored) {
                try {
                    EmptyStatement.ignore(ignored);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(is);
                    throw throwable;
                }
                IOUtil.closeResource(is);
            }
        }
        IOUtil.closeResource(is);
        String urlStr = "http://versioncheck.hazelcast.com/version.jsp?version=" + version + "&m=" + hazelcastNode.getLocalMember().getUuid() + "&e=" + isEnterprise + "&l=" + this.toMD5String(hazelcastNode.getConfig().getLicenseKey()) + "&p=" + downloadId + "&c=" + this.toMD5String(hazelcastNode.getConfig().getGroupConfig().getName()) + "&crsz=" + this.convertToLetter(hazelcastNode.getClusterService().getMembers().size()) + "&cssz=" + this.convertToLetter(hazelcastNode.clientEngine.getClientEndpointCount());
        this.fetchWebService(urlStr);
    }

    private String toMD5String(String str) {
        if (this.md == null || str == null) {
            return "NULL";
        }
        byte[] byteData = this.md.digest(str.getBytes(Charset.forName("UTF-8")));
        StringBuilder sb = new StringBuilder();
        for (byte aByteData : byteData) {
            sb.append(Integer.toString((aByteData & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    private Document fetchWebService(String urlStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

