/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.client;

import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.client.PartitionsResponse;
import java.security.Permission;
import java.util.Collection;
import java.util.HashMap;

public final class GetPartitionsRequest
extends CallableClientRequest
implements Portable,
RetryableRequest {
    public Object call() throws Exception {
        InternalPartitionService service = (InternalPartitionService)this.getService();
        service.firstArrangement();
        ClusterService clusterService = this.getClientEngine().getClusterService();
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        Address[] addresses = new Address[memberList.size()];
        HashMap<Address, Integer> addressMap = new HashMap<Address, Integer>(memberList.size());
        int k = 0;
        for (MemberImpl member : memberList) {
            Address address;
            addresses[k] = address = member.getAddress();
            addressMap.put(address, k);
            ++k;
        }
        InternalPartition[] partitions = service.getPartitions();
        int[] indexes = new int[partitions.length];
        for (int i = 0; i < indexes.length; ++i) {
            Integer idx;
            Address owner = partitions[i].getOwnerOrNull();
            int index = -1;
            if (owner != null && (idx = (Integer)addressMap.get(owner)) != null) {
                index = idx;
            }
            indexes[i] = index;
        }
        return new PartitionsResponse(addresses, indexes);
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

