/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.MemoryInfoAccessor;
import com.hazelcast.util.RuntimeMemoryInfoAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MaxSizeChecker {
    private static final int ONE_HUNDRED_PERCENT = 100;
    private static final int EVICTION_START_THRESHOLD_PERCENTAGE = 95;
    private static final int ONE_KILOBYTE = 1024;
    private static final int ONE_MEGABYTE = 0x100000;
    private final MemoryInfoAccessor memoryInfoAccessor;
    private final MapServiceContext mapServiceContext;

    public MaxSizeChecker(MapServiceContext mapServiceContext) {
        this(new RuntimeMemoryInfoAccessor(), mapServiceContext);
    }

    public MaxSizeChecker(MemoryInfoAccessor memoryInfoAccessor, MapServiceContext mapServiceContext) {
        this.memoryInfoAccessor = memoryInfoAccessor;
        this.mapServiceContext = mapServiceContext;
    }

    public boolean checkEvictable(MapContainer mapContainer, int partitionId) {
        boolean result;
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        MaxSizeConfig.MaxSizePolicy maxSizePolicy = maxSizeConfig.getMaxSizePolicy();
        switch (maxSizePolicy) {
            case PER_NODE: {
                result = this.isEvictablePerNode(mapContainer);
                break;
            }
            case PER_PARTITION: {
                result = this.isEvictablePerPartition(mapContainer, partitionId);
                break;
            }
            case USED_HEAP_PERCENTAGE: {
                result = this.isEvictableHeapPercentage(mapContainer);
                break;
            }
            case USED_HEAP_SIZE: {
                result = this.isEvictableHeapSize(mapContainer);
                break;
            }
            case FREE_HEAP_PERCENTAGE: {
                result = this.isEvictableFreeHeapPercentage(mapContainer);
                break;
            }
            case FREE_HEAP_SIZE: {
                result = this.isEvictableFreeHeapSize(mapContainer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate max size policy [" + (Object)((Object)maxSizePolicy) + ']');
            }
        }
        return result;
    }

    private boolean isEvictablePerNode(MapContainer mapContainer) {
        int nodeTotalSize = 0;
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        int maxSize = MaxSizeChecker.getApproximateMaxSize(maxSizeConfig.getSize());
        String mapName = mapContainer.getName();
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        List<Integer> partitionIds = this.findPartitionIds();
        for (int partitionId : partitionIds) {
            PartitionContainer container = mapServiceContext.getPartitionContainer(partitionId);
            if (container == null || (nodeTotalSize += this.getRecordStoreSize(mapName, container)) < maxSize) continue;
            return true;
        }
        return false;
    }

    private boolean isEvictablePerPartition(MapContainer mapContainer, int partitionId) {
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        int maxSize = MaxSizeChecker.getApproximateMaxSize(maxSizeConfig.getSize());
        String mapName = mapContainer.getName();
        PartitionContainer container = mapServiceContext.getPartitionContainer(partitionId);
        if (container == null) {
            return false;
        }
        int size = this.getRecordStoreSize(mapName, container);
        return size >= maxSize;
    }

    private boolean isEvictableHeapSize(MapContainer mapContainer) {
        long usedHeapSize = this.getUsedHeapSize(mapContainer);
        if (usedHeapSize == -1L) {
            return false;
        }
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        int maxSize = MaxSizeChecker.getApproximateMaxSize(maxSizeConfig.getSize());
        return (long)maxSize < usedHeapSize / 0x100000L;
    }

    private boolean isEvictableFreeHeapSize(MapContainer mapContainer) {
        long currentFreeHeapSize = this.getAvailableMemory();
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        int minFreeHeapSize = MaxSizeChecker.getApproximateMaxSize(maxSizeConfig.getSize());
        return (long)minFreeHeapSize > currentFreeHeapSize / 0x100000L;
    }

    private boolean isEvictableHeapPercentage(MapContainer mapContainer) {
        long total;
        long usedHeapSize = this.getUsedHeapSize(mapContainer);
        if (usedHeapSize == -1L) {
            return false;
        }
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        int maxSize = MaxSizeChecker.getApproximateMaxSize(maxSizeConfig.getSize());
        return (double)maxSize < 100.0 * (double)usedHeapSize / (double)(total = this.getTotalMemory());
    }

    private boolean isEvictableFreeHeapPercentage(MapContainer mapContainer) {
        long total;
        long currentFreeHeapSize = this.getAvailableMemory();
        MaxSizeConfig maxSizeConfig = mapContainer.getMapConfig().getMaxSizeConfig();
        int freeHeapPercentage = MaxSizeChecker.getApproximateMaxSize(maxSizeConfig.getSize());
        return (double)freeHeapPercentage > 100.0 * (double)currentFreeHeapSize / (double)(total = this.getTotalMemory());
    }

    private long getTotalMemory() {
        return this.memoryInfoAccessor.getTotalMemory();
    }

    private long getFreeMemory() {
        return this.memoryInfoAccessor.getFreeMemory();
    }

    private long getMaxMemory() {
        return this.memoryInfoAccessor.getMaxMemory();
    }

    private long getAvailableMemory() {
        long totalMemory = this.getTotalMemory();
        long freeMemory = this.getFreeMemory();
        long maxMemory = this.getMaxMemory();
        return freeMemory + (maxMemory - totalMemory);
    }

    private long getUsedHeapSize(MapContainer mapContainer) {
        long heapCost = 0L;
        String mapName = mapContainer.getName();
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        List<Integer> partitionIds = this.findPartitionIds();
        for (int partitionId : partitionIds) {
            PartitionContainer container = mapServiceContext.getPartitionContainer(partitionId);
            if (container == null) continue;
            heapCost += this.getRecordStoreHeapCost(mapName, container);
        }
        return heapCost += mapContainer.getNearCacheSizeEstimator().getSize();
    }

    private int getRecordStoreSize(String mapName, PartitionContainer partitionContainer) {
        RecordStore existingRecordStore = partitionContainer.getExistingRecordStore(mapName);
        if (existingRecordStore == null) {
            return 0;
        }
        return existingRecordStore.size();
    }

    private long getRecordStoreHeapCost(String mapName, PartitionContainer partitionContainer) {
        RecordStore existingRecordStore = partitionContainer.getExistingRecordStore(mapName);
        if (existingRecordStore == null) {
            return 0L;
        }
        return existingRecordStore.getHeapCost();
    }

    public static int getApproximateMaxSize(int maxSizeFromConfig) {
        return maxSizeFromConfig * 95 / 100;
    }

    private List<Integer> findPartitionIds() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        ArrayList<Integer> partitionIds = null;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            if (!this.isOwnerOrBackup(partitionId)) continue;
            if (partitionIds == null) {
                partitionIds = new ArrayList<Integer>();
            }
            partitionIds.add(partitionId);
        }
        return partitionIds == null ? Collections.emptyList() : partitionIds;
    }

    private boolean isOwnerOrBackup(int partitionId) {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        InternalPartition partition = partitionService.getPartition(partitionId, false);
        Address thisAddress = nodeEngine.getThisAddress();
        return partition.isOwnerOrBackup(thisAddress);
    }
}

