/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.IMap;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.util.JsonUtil;
import java.util.LinkedHashMap;

public class GetMapEntryRequest
implements ConsoleRequest {
    private String mapName;
    private String type;
    private String key;

    public GetMapEntryRequest() {
    }

    public GetMapEntryRequest(String type, String mapName, String key) {
        this.type = type;
        this.mapName = mapName;
        this.key = key;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public Object readResponse(JsonObject in) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (JsonObject.Member property : in) {
            properties.put(property.getName(), property.getValue().asString());
        }
        return properties;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) throws Exception {
        IMap map = mcs.getHazelcastInstance().getMap(this.mapName);
        JsonObject result = new JsonObject();
        EntryView entry = null;
        if (this.type.equals("string")) {
            entry = map.getEntryView(this.key);
        } else if (this.type.equals("long")) {
            entry = map.getEntryView(Long.valueOf(this.key));
        } else if (this.type.equals("integer")) {
            entry = map.getEntryView(Integer.valueOf(this.key));
        }
        if (entry != null) {
            Object value = entry.getValue();
            result.add("browse_value", value != null ? value.toString() : "null");
            result.add("browse_class", value != null ? value.getClass().getName() : "null");
            result.add("memory_cost", Long.toString(entry.getCost()));
            result.add("date_creation_time", Long.toString(entry.getCreationTime()));
            result.add("date_expiration_time", Long.toString(entry.getExpirationTime()));
            result.add("browse_hits", Long.toString(entry.getHits()));
            result.add("date_access_time", Long.toString(entry.getLastAccessTime()));
            result.add("date_update_time", Long.toString(entry.getLastUpdateTime()));
            result.add("browse_version", Long.toString(entry.getVersion()));
        }
        root.add("result", result);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("mapName", this.mapName);
        root.add("type", this.type);
        root.add("key", this.key);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.mapName = JsonUtil.getString(json, "mapName");
        this.type = JsonUtil.getString(json, "type");
        this.key = JsonUtil.getString(json, "key");
    }
}

