/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.collection.client.CollectionRequest;
import com.hazelcast.collection.list.ListSubOperation;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ListSubRequest
extends CollectionRequest {
    private int from;
    private int to;

    public ListSubRequest() {
    }

    public ListSubRequest(String name, int from, int to) {
        super(name);
        this.from = from;
        this.to = to;
    }

    @Override
    protected Operation prepareOperation() {
        return new ListSubOperation(this.name, this.from, this.to);
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("f", this.from);
        writer.writeInt("t", this.to);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.from = reader.readInt("f");
        this.to = reader.readInt("t");
    }

    @Override
    public String getRequiredAction() {
        return "read";
    }

    @Override
    public String getMethodName() {
        if (this.from == -1 && this.to == -1) {
            return "listIterator";
        }
        return "subList";
    }

    @Override
    public Object[] getParameters() {
        if (this.from == -1 && this.to == -1) {
            return null;
        }
        return new Object[]{this.from, this.to};
    }
}

