/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class AcctModCmd
extends AcctCommand {
    public static final int REGSTATUS_NONE = 1;
    public static final int REGSTATUS_PARTIAL = 2;
    public static final int REGSTATUS_FULL = 3;
    private static final int TYPE_SN = 1;
    private static final int TYPE_EMAIL = 17;
    private static final int TYPE_REGSTATUS = 19;
    private final String sn;
    private final String email;
    private final int regstatus;

    protected AcctModCmd(SnacPacket snacPacket) {
        super(4);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        this.sn = immutableTlvChain.getString(1);
        this.email = immutableTlvChain.getString(17);
        this.regstatus = immutableTlvChain.getUShort(19);
    }

    public AcctModCmd(int n) {
        this(null, null, n);
    }

    public AcctModCmd(String string, String string2) {
        this(string, string2, -1);
    }

    public AcctModCmd(String string, String string2, int n) {
        super(4);
        DefensiveTools.checkRange(n, "regstatus", -1);
        this.sn = string;
        this.email = string2;
        this.regstatus = n;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final String getEmail() {
        return this.email;
    }

    public final int getRegVisStatus() {
        return this.regstatus;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(outputStream);
        }
        if (this.email != null) {
            Tlv.getStringInstance(17, this.email).write(outputStream);
        }
        if (this.regstatus != -1) {
            Tlv.getUShortInstance(19, this.regstatus).write(outputStream);
        }
    }

    public String toString() {
        return "AccountModCmd: sn=" + this.sn + ", email=" + this.email + ", regstatus=" + this.regstatus;
    }
}

