/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Touch
extends Task {
    private File file;
    private long millis;
    private String dateTime;
    private Vector filesets;
    private Vector filelists;
    private FileUtils fileUtils;

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public void setDatetime(String string) {
        this.dateTime = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.filelists.addElement(fileList);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        long l = this.millis;
        if (this.file == null && this.filesets.size() == 0 && this.filelists.size() == 0) {
            throw new BuildException("Specify at least one source - a file, filelist or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to touch directories.");
        }
        try {
            if (this.dateTime != null) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
                try {
                    this.setMillis(dateFormat.parse(this.dateTime).getTime());
                }
                catch (ParseException parseException) {
                    dateFormat = DateFormat.getDateTimeInstance(3, 2, Locale.US);
                    try {
                        this.setMillis(dateFormat.parse(this.dateTime).getTime());
                    }
                    catch (ParseException parseException2) {
                        throw new BuildException(parseException2.getMessage(), parseException, this.getLocation());
                    }
                }
                if (this.millis < 0L) {
                    throw new BuildException("Date of " + this.dateTime + " results in negative milliseconds value relative to epoch (January 1, 1970, 00:00:00 GMT).");
                }
            }
            this.touch();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.millis = l;
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.millis = l;
            return;
        }
    }

    protected void touch() throws BuildException {
        String[] stringArray;
        Object object;
        DataType dataType;
        boolean bl = false;
        if (this.millis < 0L) {
            bl = true;
            this.millis = System.currentTimeMillis();
        }
        if (this.file != null) {
            this.touch(this.file);
        }
        int n = 0;
        while (n < this.filesets.size()) {
            dataType = (FileSet)this.filesets.elementAt(n);
            object = ((AbstractFileSet)dataType).getDirectoryScanner(this.getProject());
            stringArray = ((AbstractFileSet)dataType).getDir(this.getProject());
            String[] stringArray2 = ((DirectoryScanner)object).getIncludedFiles();
            String[] stringArray3 = ((DirectoryScanner)object).getIncludedDirectories();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                this.touch(new File((File)stringArray, stringArray2[n2]));
                ++n2;
            }
            n2 = 0;
            while (n2 < stringArray3.length) {
                this.touch(new File((File)stringArray, stringArray3[n2]));
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.filelists.size()) {
            dataType = (FileList)this.filelists.elementAt(n);
            object = ((FileList)dataType).getDir(this.getProject());
            stringArray = ((FileList)dataType).getFiles(this.getProject());
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.touch(new File((File)object, stringArray[n3]));
                ++n3;
            }
            ++n;
        }
        if (bl) {
            this.millis = -1;
        }
    }

    protected void touch(File file) throws BuildException {
        if (!file.exists()) {
            this.log("Creating " + file, 2);
            try {
                this.fileUtils.createNewFile(file);
            }
            catch (IOException iOException) {
                throw new BuildException("Could not create " + file, iOException, this.getLocation());
            }
        }
        if (!file.canWrite()) {
            throw new BuildException("Can not change modification date of read-only file " + file);
        }
        this.fileUtils.setFileLastModified(file, this.millis);
    }

    private final /* synthetic */ void this() {
        this.millis = -1;
        this.filesets = new Vector();
        this.filelists = new Vector();
    }

    public Touch() {
        this.this();
        this.fileUtils = FileUtils.newFileUtils();
    }
}

