/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractTrillianCryptRvCmd
extends RvCommand {
    public static final int VERSION_DEFAULT = 1;
    public static final int CMDTYPE_REQUEST = 0;
    public static final int CMDTYPE_ACCEPT = 1;
    public static final int CMDTYPE_BEGIN = 2;
    public static final int CMDTYPE_MESSAGE = 3;
    public static final int CMDTYPE_CLOSE = 4;
    private static final int TYPE_VERSION = 999;
    private static final int TYPE_CMDTYPE = 1000;
    private final int version;
    private final int cmdType;
    private final TlvChain extraTlvs;

    public static int getTrillianCmdType(RecvRvIcbm icbm) {
        DefensiveTools.checkNull((Object)icbm, (String)"icbm");
        ByteBlock rvData = icbm.getRvData();
        if (rvData == null) {
            return -1;
        }
        ImmutableTlvChain chain = TlvTools.readChain(rvData);
        return chain.getUShort(1000);
    }

    protected static BigInteger getBigIntFromHexBlock(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        String hexString = BinaryTools.getNullPadded((ByteBlock)block).getString();
        return new BigInteger(hexString, 16);
    }

    protected static byte[] getBigIntHexBlock(BigInteger num) throws IOException, IllegalArgumentException {
        DefensiveTools.checkNull((Object)num, (String)"num");
        byte[] data = num.toString(16).getBytes("US-ASCII");
        if (data.length > 32) {
            throw new IllegalArgumentException("number (" + num + ") is too " + "large to fit into 32 hexadecimal digits");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(33);
        for (int i = data.length; i < 32; ++i) {
            bout.write(48);
        }
        bout.write(data);
        bout.write(0);
        return bout.toByteArray();
    }

    protected AbstractTrillianCryptRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        ImmutableTlvChain chain = TlvTools.readChain(icbm.getRvData());
        this.version = chain.getUShort(999);
        this.cmdType = chain.getUShort(1000);
        MutableTlvChain extras = TlvTools.getMutableCopy(chain);
        extras.removeTlvs(999, 1000);
        this.extraTlvs = extras;
    }

    protected AbstractTrillianCryptRvCmd(int cmdType) {
        this(1, cmdType);
    }

    protected AbstractTrillianCryptRvCmd(int encVersion, int cmdType) {
        super(0, CapabilityBlock.BLOCK_TRILLIANCRYPT);
        DefensiveTools.checkRange((int)encVersion, (String)"version", (int)0);
        DefensiveTools.checkRange((int)cmdType, (String)"cmdType", (int)0);
        this.version = encVersion;
        this.cmdType = cmdType;
        this.extraTlvs = null;
    }

    protected final int getVersion() {
        return this.version;
    }

    protected final int getCmdType() {
        return this.cmdType;
    }

    protected final TlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    public void writeRvData(OutputStream out) throws IOException {
        Tlv.getUShortInstance(999, this.version).write(out);
        Tlv.getUShortInstance(1000, this.cmdType).write(out);
        this.writeExtraTlvs(out);
    }

    protected abstract void writeExtraTlvs(OutputStream var1) throws IOException;
}

