/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendfile;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.rvcmd.sendfile.FileSendBlock;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.TlvChain;

public class FileSendReqRvCmd
extends AbstractRequestRvCmd
implements ConnectionRequestRvCmd {
    private final InvitationMessage invMessage;
    private final RvConnectionInfo connInfo;
    private final FileSendBlock fileSendBlock;

    public FileSendReqRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getRvTlvs();
        this.invMessage = InvitationMessage.readInvitationMessage(chain);
        ByteBlock sendData = this.getServiceData();
        this.fileSendBlock = sendData == null ? null : FileSendBlock.readFileSendBlock(sendData);
        this.connInfo = RvConnectionInfo.readConnectionInfo(chain);
    }

    public FileSendReqRvCmd(InvitationMessage message, RvConnectionInfo connInfo, FileSendBlock fileInfo) {
        this(1, message, connInfo, fileInfo);
    }

    public FileSendReqRvCmd(RvConnectionInfo connInfo, int requestIndex) {
        this(requestIndex, null, connInfo, null);
    }

    public FileSendReqRvCmd(int requestIndex, InvitationMessage message, RvConnectionInfo connInfo, FileSendBlock fileInfo) {
        super(CapabilityBlock.BLOCK_FILE_SEND, requestIndex);
        this.connInfo = connInfo;
        this.fileSendBlock = fileInfo;
        this.invMessage = message;
    }

    public final InvitationMessage getMessage() {
        return this.invMessage;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    public final FileSendBlock getFileSendBlock() {
        return this.fileSendBlock;
    }

    public void writeRvTlvs(OutputStream out) throws IOException {
        if (this.invMessage != null) {
            this.invMessage.write(out);
        }
        if (this.connInfo != null) {
            this.connInfo.write(out);
        }
    }

    protected boolean hasServiceData() {
        return this.fileSendBlock != null;
    }

    protected void writeServiceData(OutputStream out) throws IOException {
        if (this.fileSendBlock != null) {
            this.fileSendBlock.write(out);
        }
    }

    public String toString() {
        return "FileSendReqRvCmd: reqIndex=" + this.getRequestIndex() + ", message='" + this.invMessage + "'" + ", connInfo=" + this.connInfo + ", fileSendBlock=" + this.fileSendBlock;
    }
}

