/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;

public class SendBuddyIconRvCmd
extends AbstractRequestRvCmd {
    public static final String ICONIDSTRING_DEFAULT = "AVT1picture.id";
    private final OldIconHashInfo hash;
    private final ByteBlock iconData;
    private final LiveWritable iconWriter;
    private final String iconId;

    public SendBuddyIconRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        this.iconWriter = null;
        ByteBlock byteBlock = this.getServiceData();
        OldIconHashInfo oldIconHashInfo = null;
        ByteBlock byteBlock2 = null;
        String string = null;
        if (byteBlock != null && (oldIconHashInfo = OldIconHashInfo.readIconHashFromRvData(byteBlock)) != null) {
            int n = oldIconHashInfo.getRvDataFormatLength();
            int n2 = (int)oldIconHashInfo.getIconSize();
            if (byteBlock.getLength() >= n + n2) {
                byteBlock2 = byteBlock.subBlock(n, n2);
                ByteBlock byteBlock3 = byteBlock.subBlock(n + n2);
                if (byteBlock3.getLength() > 0) {
                    string = BinaryTools.getAsciiString(byteBlock3);
                }
            }
        }
        this.hash = oldIconHashInfo;
        this.iconData = byteBlock2;
        this.iconId = string;
    }

    public SendBuddyIconRvCmd(OldIconHashInfo oldIconHashInfo, LiveWritable liveWritable) {
        this(oldIconHashInfo, liveWritable, ICONIDSTRING_DEFAULT);
    }

    public SendBuddyIconRvCmd(OldIconHashInfo oldIconHashInfo, LiveWritable liveWritable, String string) {
        super(CapabilityBlock.BLOCK_ICON);
        DefensiveTools.checkNull(oldIconHashInfo, "hash");
        DefensiveTools.checkNull(liveWritable, "iconDataWriter");
        this.hash = oldIconHashInfo;
        this.iconData = null;
        this.iconWriter = liveWritable;
        this.iconId = string;
    }

    public final OldIconHashInfo getIconHash() {
        return this.hash;
    }

    public final ByteBlock getIconData() {
        return this.iconData;
    }

    public final String getIconIdString() {
        return this.iconId;
    }

    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
        if (this.hash != null) {
            this.hash.writeToRvData(outputStream);
            if (this.iconData != null || this.iconWriter != null) {
                if (this.iconWriter != null) {
                    this.iconWriter.write(outputStream);
                } else {
                    this.iconData.write(outputStream);
                }
                if (this.iconId != null) {
                    outputStream.write(BinaryTools.getAsciiBytes(this.iconId));
                }
            }
        }
    }

    public String toString() {
        return "SendBuddyIconRvCmd: hash=" + this.hash + ", icon=" + (this.iconData == null ? -1 : this.iconData.getLength()) + " bytes (id=" + this.iconId + ")";
    }
}

