/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework.launch;

import java.util.EventListener;
import java.util.EventObject;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jitsi.impl.osgi.framework.AsyncExecutor;
import org.jitsi.impl.osgi.framework.launch.EventListenerList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class EventDispatcher {
    private static final Logger logger = Logger.getLogger(EventDispatcher.class.getName());
    private final AsyncExecutor<Command> executor = new AsyncExecutor();
    private final EventListenerList listeners = new EventListenerList();

    public <T extends EventListener> boolean addListener(Bundle bundle, Class<T> clazz, T listener) {
        return this.listeners.add(bundle, clazz, listener);
    }

    void fireBundleEvent(BundleEvent event) {
        this.fireEvent(BundleListener.class, (EventObject)event);
    }

    private <T extends EventListener> void fireEvent(Class<T> clazz, EventObject event) {
        EventListener[] listeners = this.listeners.getListeners(clazz);
        if (listeners.length != 0) {
            try {
                this.executor.execute(new Command(clazz, event));
            }
            catch (RejectedExecutionException ree) {
                logger.log(Level.SEVERE, "Error firing event", ree);
            }
        }
    }

    void fireServiceEvent(ServiceEvent event) {
        this.fireEvent(ServiceListener.class, (EventObject)event);
    }

    public <T extends EventListener> boolean removeListener(Bundle bundle, Class<T> clazz, T listener) {
        return this.listeners.remove(bundle, clazz, listener);
    }

    public boolean removeListeners(Bundle bundle) {
        return this.listeners.removeAll(bundle);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private class Command
    implements Runnable {
        private final Class<? extends EventListener> clazz;
        private final EventObject event;

        public <T extends EventListener> Command(Class<T> clazz, EventObject event) {
            this.clazz = clazz;
            this.event = event;
        }

        @Override
        public void run() {
            EventListener[] listeners;
            for (EventListener listener : listeners = EventDispatcher.this.listeners.getListeners(this.clazz)) {
                try {
                    if (BundleListener.class.equals(this.clazz)) {
                        ((BundleListener)listener).bundleChanged((BundleEvent)this.event);
                        continue;
                    }
                    if (!ServiceListener.class.equals(this.clazz)) continue;
                    ((ServiceListener)listener).serviceChanged((ServiceEvent)this.event);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Error dispatching event", t);
                    if (FrameworkListener.class.equals(this.clazz) && ((FrameworkEvent)this.event).getType() == 2) continue;
                }
            }
        }
    }
}

