/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPRequest;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.CSeqHeader;

public class CSeq
extends SIPHeader
implements CSeqHeader {
    private static final long serialVersionUID = -5405798080040422910L;
    protected Long seqno;
    protected String method;

    public CSeq() {
        super("CSeq");
    }

    public CSeq(long l, String string) {
        this();
        this.seqno = new Long(l);
        this.method = SIPRequest.getCannonicalName(string);
    }

    public boolean equals(Object object) {
        if (object instanceof CSeqHeader) {
            CSeqHeader cSeqHeader = (CSeqHeader)object;
            return this.getSeqNumber() == cSeqHeader.getSeqNumber() && this.getMethod().equals(cSeqHeader.getMethod());
        }
        return false;
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        return stringBuffer.append(this.seqno).append(" ").append(this.method.toUpperCase());
    }

    public String getMethod() {
        return this.method;
    }

    public void setSeqNumber(long l) throws InvalidArgumentException {
        if (l < 0L) {
            throw new InvalidArgumentException("JAIN-SIP Exception, CSeq, setSequenceNumber(), the sequence number parameter is < 0 : " + l);
        }
        if (l > 0x80000000L) {
            throw new InvalidArgumentException("JAIN-SIP Exception, CSeq, setSequenceNumber(), the sequence number parameter is too large : " + l);
        }
        this.seqno = new Long(l);
    }

    public void setSequenceNumber(int n) throws InvalidArgumentException {
        this.setSeqNumber(n);
    }

    public void setMethod(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, CSeq, setMethod(), the meth parameter is null");
        }
        this.method = SIPRequest.getCannonicalName(string);
    }

    public int getSequenceNumber() {
        if (this.seqno == null) {
            return 0;
        }
        return this.seqno.intValue();
    }

    public long getSeqNumber() {
        return this.seqno;
    }
}

