/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.search.UserSearch;

public class UserSearchManager {
    private Connection con;
    private UserSearch userSearch;

    public UserSearchManager(Connection con) {
        this.con = con;
        this.userSearch = new UserSearch();
    }

    public Form getSearchForm(String searchService) throws XMPPException {
        return this.userSearch.getSearchForm(this.con, searchService);
    }

    public ReportedData getSearchResults(Form searchForm, String searchService) throws XMPPException {
        return this.userSearch.sendSearchForm(this.con, searchForm, searchService);
    }

    public Collection<String> getSearchServices() throws XMPPException {
        ArrayList<String> searchServices = new ArrayList<String>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(this.con);
        DiscoverItems items = discoManager.discoverItems(this.con.getServiceName());
        Iterator<DiscoverItems.Item> iter = items.getItems();
        while (iter.hasNext()) {
            DiscoverItems.Item item = iter.next();
            try {
                DiscoverInfo info;
                try {
                    info = discoManager.discoverInfo(item.getEntityID());
                }
                catch (XMPPException e) {
                    continue;
                }
                if (!info.containsFeature("jabber:iq:search")) continue;
                searchServices.add(item.getEntityID());
            }
            catch (Exception e) {
                break;
            }
        }
        return searchServices;
    }
}

