/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.entity.SecurityAuditLog;
import org.jivesoftware.openfire.plugin.rest.entity.SecurityAuditLogs;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.security.AuditWriteOnlyException;
import org.jivesoftware.openfire.security.SecurityAuditEvent;
import org.jivesoftware.openfire.security.SecurityAuditManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAuditLogController {
    public static final SecurityAuditLogController INSTANCE = new SecurityAuditLogController();
    private static final Logger LOG = LoggerFactory.getLogger(SecurityAuditLogController.class);

    public static SecurityAuditLogController getInstance() {
        return INSTANCE;
    }

    public SecurityAuditLogs getSecurityAuditLogs(String username, int offset, int limit, long startTimeTimeStamp, long endTimeTimeStamp) throws ServiceException {
        Date startTime = null;
        Date endTime = null;
        LOG.error("username: " + username);
        LOG.error("offset: " + offset);
        LOG.error("limit: " + limit);
        LOG.error("startTimeTimeStamp: " + startTimeTimeStamp);
        LOG.error("endTimeTimeStamp: " + endTimeTimeStamp);
        if (startTimeTimeStamp != 0L) {
            startTime = new Date(startTimeTimeStamp * 1000L);
        }
        if (endTimeTimeStamp != 0L) {
            endTime = new Date(endTimeTimeStamp * 1000L);
        }
        List events = new ArrayList();
        try {
            events = SecurityAuditManager.getInstance().getEvents(username, Integer.valueOf(offset), Integer.valueOf(limit), startTime, endTime);
        }
        catch (AuditWriteOnlyException e) {
            throw new ServiceException("Could not get security audit logs, because the permission is set to write only", "SecurityLogs", "AuditWriteOnlyException", Response.Status.FORBIDDEN);
        }
        ArrayList<SecurityAuditLog> securityAuditLogs = new ArrayList<SecurityAuditLog>();
        for (SecurityAuditEvent event : events) {
            SecurityAuditLog log = new SecurityAuditLog(event.getMsgID(), event.getUsername(), event.getEventStamp().getTime() / 1000L, event.getSummary(), event.getNode(), event.getDetails());
            securityAuditLogs.add(log);
        }
        return new SecurityAuditLogs(securityAuditLogs);
    }
}

