/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.Mode;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.ChannelModeCommand;
import f00f.net.irc.martyr.commands.UserModeCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeCommand
implements InCommand,
OutCommand {
    static Logger log = Logger.getLogger(ModeCommand.class);
    public static final String IDENTIFIER = "MODE";
    private String source;

    @Override
    public Iterator getAttributeKeys() {
        return new LinkedList().iterator();
    }

    @Override
    public String getAttribute(String key) {
        return null;
    }

    public static void registerMode(Map<Character, Mode> modes, Mode mode) {
        Character modeChar = Character.valueOf(mode.getChar());
        if (modes.get(modeChar) != null) {
            log.error((Object)("ModeCommand: Warning: Two modes with same letter: " + modes.get(modeChar) + " and " + mode));
        }
        modes.put(modeChar, mode);
    }

    @Override
    public State getState() {
        return State.REGISTERED;
    }

    @Override
    public void selfRegister(CommandRegister reg) {
        reg.addCommand(IDENTIFIER, this);
    }

    @Override
    public String getIrcIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public InCommand parse(String prefix, String identifier, String params) {
        StringTokenizer tokens = new StringTokenizer(params);
        String str = tokens.nextToken();
        if (str == null) {
            return null;
        }
        if (Channel.isChannel(str)) {
            return new ChannelModeCommand(prefix, str, tokens);
        }
        return new UserModeCommand(prefix, str, tokens);
    }

    @Override
    public String render() {
        throw new IllegalStateException("Don't try to send ModeCommand!");
    }

    @Override
    public void setSourceString(String source) {
        this.source = source;
    }

    @Override
    public String getSourceString() {
        return this.source;
    }

    @Override
    public boolean updateClientState(ClientState cs) {
        return false;
    }

    public String toString() {
        return "ModeCommand";
    }

    public List<Mode> parseModes(Map<Character, Mode> modes, StringTokenizer tokens) {
        LinkedList<Mode> results = new LinkedList<Mode>();
        while (tokens.hasMoreTokens()) {
            this.parseOneModeSet(modes, tokens, results);
        }
        return results;
    }

    private void parseOneModeSet(Map<Character, Mode> modes, StringTokenizer tokens, List<Mode> results) {
        LinkedList<Mode> localModes = new LinkedList<Mode>();
        Mode.Sign sign = Mode.Sign.NOSIGN;
        String chars = tokens.nextToken();
        int stop = chars.length();
        for (int i = 0; i < stop; ++i) {
            char lookingAt = chars.charAt(i);
            if (lookingAt == '+') {
                sign = Mode.Sign.POSITIVE;
                continue;
            }
            if (lookingAt == '-') {
                sign = Mode.Sign.NEGATIVE;
                continue;
            }
            if (lookingAt == ':') continue;
            Mode mode = modes.get(Character.valueOf(lookingAt));
            if (mode == null) {
                log.fatal((Object)("ModeCommand: Unknown mode: " + lookingAt));
                continue;
            }
            mode = mode.newInstance();
            mode.setSign(sign);
            localModes.add(mode);
        }
        for (Mode localMode : localModes) {
            if (localMode != null && localMode.requiresParam() && tokens.hasMoreTokens()) {
                localMode.setParam(tokens.nextToken());
            }
            results.add(localMode);
        }
    }
}

