/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.DirectoryDisplay;
import com.install4j.runtime.installer.frontend.components.FSRootChooser;
import com.install4j.runtime.installer.frontend.components.NextScreenListener;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DirectoryChooser
extends JPanel {
    private static final String BAD_CHARS = ":*?\"<>|" + (InstallerUtil.isWindows() ? "/" : "\\");
    private File initalParentDirectory;
    private String standardDirectoryName;
    private InternalValidator internalValidator;
    private NextScreenListener nextScreenListener;
    private JTextField txtDirectory;
    private DirectoryDisplay directoryDisplay;
    private FSRootChooser fsRootChooser;
    private boolean inRootChange = false;
    static /* synthetic */ Class class$java$awt$Window;

    public DirectoryChooser(File file, String string, InternalValidator internalValidator, NextScreenListener nextScreenListener) {
        this.initalParentDirectory = file;
        this.standardDirectoryName = string;
        this.internalValidator = internalValidator;
        this.nextScreenListener = nextScreenListener;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.txtDirectory.setEnabled(bl);
        this.directoryDisplay.setEnabled(bl);
        this.fsRootChooser.setEnabled(bl);
    }

    public File getSelectedDirectory() {
        return new File(this.getSelectedDirectoryName());
    }

    public boolean checkSelectedDirectory() {
        File file;
        String string = this.getSelectedDirectoryName();
        Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = DirectoryChooser.class$("java.awt.Window")) : class$java$awt$Window, this);
        FileResourceBundle fileResourceBundle = Messages.getMessages();
        if (string.length() == 0) {
            GUIHelper.showMessage(window, fileResourceBundle.getString("MustEnterDirectory"), 2);
            return false;
        }
        if (!InstallerUtil.isWindows() && !InstallerUtil.isMacOS() && string.indexOf(32) > -1) {
            GUIHelper.showMessage(window, MessageFormat.format(fileResourceBundle.getString("NoDirNameWithSpace"), BAD_CHARS), 2);
            return false;
        }
        char[] cArray = BAD_CHARS.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            int n = string.indexOf(cArray[i]);
            if (n < 0 || cArray[i] == ':' && n == 1 && string.lastIndexOf(58) == n && InstallerUtil.isWindows()) continue;
            GUIHelper.showMessage(window, MessageFormat.format(fileResourceBundle.getString("BadDirName32"), BAD_CHARS), 2);
            return false;
        }
        try {
            file = new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            GUIHelper.showMessage(window, MessageFormat.format(fileResourceBundle.getString("InvalidDirectory"), string), 2);
            return false;
        }
        return this.internalValidator == null || this.internalValidator.validateInternally(file);
    }

    public void focusTextField() {
        this.txtDirectory.requestFocus();
        this.txtDirectory.setSelectionStart(0);
        this.txtDirectory.setSelectionEnd(this.txtDirectory.getDocument().getLength());
    }

    private void setupControls() {
        this.txtDirectory = new JTextField(this.getSuggestedPath(this.initalParentDirectory));
        this.directoryDisplay = new DirectoryDisplay(this.initalParentDirectory);
        this.fsRootChooser = new FSRootChooser(this.initalParentDirectory);
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtDirectory, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.directoryDisplay, gridBagConstraints);
        if (InstallerUtil.isWindows()) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this.fsRootChooser, gridBagConstraints);
        }
    }

    private void setupEventHandlers() {
        this.directoryDisplay.addPropertyChangeListener("directory", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("directory")) {
                    DirectoryChooser.this.syncTextArea();
                }
            }
        });
        this.fsRootChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryChooser.this.syncDirectoryDisplay();
            }
        });
        KeyboardUtil.addAccelerator(0, this.txtDirectory, this.txtDirectory, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DirectoryChooser.this.nextScreenListener != null) {
                    DirectoryChooser.this.nextScreenListener.nextScreen();
                }
            }
        }, 10, 0);
    }

    private String getSelectedDirectoryName() {
        String string = this.txtDirectory.getText().trim();
        if (new File(string).getParent() != null) {
            while (string.endsWith("\\") || string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private void syncTextArea() {
        this.txtDirectory.setText(this.getSuggestedPath(this.directoryDisplay.getExpandedDirectory()));
    }

    private void syncDirectoryDisplay() {
        if (this.inRootChange) {
            return;
        }
        this.inRootChange = true;
        File file = this.fsRootChooser.getSelectedRoot();
        if (!file.canRead()) {
            this.fsRootChooser.revertToLastRoot();
            this.fsRootChooser.setPopupVisible(false);
            GUIHelper.showMessage(SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = DirectoryChooser.class$("java.awt.Window")) : class$java$awt$Window, this), "Drive " + file.getPath() + " cannot be read.", 0);
        } else {
            this.fsRootChooser.acceptRoot();
            File file2 = this.initalParentDirectory.getPath().startsWith(this.fsRootChooser.getSelectedRoot().getPath()) ? this.initalParentDirectory : this.fsRootChooser.getSelectedRoot();
            this.directoryDisplay.setExpandedDirectory(file2, true);
            this.syncTextArea();
        }
        this.inRootChange = false;
    }

    private String getSuggestedPath(File file) {
        if (this.standardDirectoryName == null) {
            return file.getPath();
        }
        return new File(file, this.standardDirectoryName).getPath();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface InternalValidator {
        public boolean validateInternally(File var1);
    }
}

