/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.in;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.RemoteStatus;
import pl.mn.communicator.User;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.in.GGIncomingPackage;

public class GGNotifyReply
implements GGIncomingPackage {
    public static final int GG_NOTIFY_REPLY = 12;
    private static final Log LOGGER = LogFactory.getLog((Class)GGNotifyReply.class);
    private Map m_statuses = new HashMap();

    public GGNotifyReply(byte[] data) {
        this.analize(data);
    }

    public int getPacketType() {
        return 12;
    }

    public Map getUsersStatus() {
        return this.m_statuses;
    }

    private void analize(byte[] data) {
        int offset = 0;
        while (offset < data.length) {
            data[offset + 3] = GGUtils.intToByte(0)[0];
            int uin = GGUtils.byteToInt(data, offset);
            int status = GGUtils.unsignedByteToInt(data[offset + 4]);
            int remoteIP = GGUtils.byteToInt(data, offset + 5);
            byte[] remoteIPByte = GGUtils.intToByte(remoteIP);
            int remotePort = GGUtils.byteToShort(data, offset + 9);
            int version = GGUtils.byteToInt(data, offset + 11);
            String description = null;
            long timeInMillis = -1L;
            if (status == 4 || status == 5 || status == 22 || status == 21) {
                boolean isTime;
                int descriptionSize = GGUtils.unsignedByteToInt(data[offset + 14]);
                boolean bl = isTime = data[offset + 15 + descriptionSize - 5] == 0;
                if (isTime) {
                    int timeInSeconds = GGUtils.byteToInt(data, offset + 15 + descriptionSize - 4);
                    timeInMillis = GGUtils.secondsToMillis(timeInSeconds);
                    descriptionSize -= 5;
                }
                description = GGUtils.byteToString(data, offset + 15, descriptionSize);
                offset += 15 + descriptionSize;
                if (isTime) {
                    offset += 5;
                }
            } else {
                offset += 14;
            }
            RemoteStatus statusBiz = GGConversion.getClientRemoteStatus(status, description, timeInMillis);
            statusBiz.setRemoteIP(remoteIPByte);
            statusBiz.setRemotePort(remotePort);
            statusBiz.setGGVersion(version);
            User.UserMode userMode = GGConversion.getUserMode(status);
            User user = new User(uin, userMode);
            this.m_statuses.put(user, statusBiz);
        }
    }
}

