/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.util.PropertyEventListener;

public class PropertyEventDispatcher {
    private static List<PropertyEventListener> listeners = new CopyOnWriteArrayList<PropertyEventListener>();

    private PropertyEventDispatcher() {
    }

    public static void addListener(PropertyEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(PropertyEventListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchEvent(String property, EventType eventType, Map params) {
        for (PropertyEventListener listener : listeners) {
            try {
                switch (eventType) {
                    case property_set: {
                        listener.propertySet(property, params);
                        break;
                    }
                    case property_deleted: {
                        listener.propertyDeleted(property, params);
                        break;
                    }
                    case xml_property_set: {
                        listener.xmlPropertySet(property, params);
                        break;
                    }
                    case xml_property_deleted: {
                        listener.xmlPropertyDeleted(property, params);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        property_set,
        property_deleted,
        xml_property_set,
        xml_property_deleted;

    }
}

