/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;

public abstract class AbstractCodec2
extends AbstractCodec {
    public static final int BUFFER_FLAG_FEC = 0x1000000;
    public static final int BUFFER_FLAG_PLC = 0x2000000;
    public static final Format[] EMPTY_FORMATS = new Format[0];
    public static final int MAX_AUDIO_SEQUENCE_NUMBERS_TO_PLC = 3;
    public static final int SEQUENCE_MAX = 65535;
    public static final int SEQUENCE_MIN = 0;
    protected int features;
    private final Class<? extends Format> formatClass;
    private final String name;
    private final Format[] supportedOutputFormats;

    public static int calculateLostSeqNoCount(long lastSeqNo, long seqNo) {
        if (lastSeqNo == 0x7FFFFFFFFFFFFFFEL) {
            return 0;
        }
        int delta = (int)(seqNo - lastSeqNo);
        if (delta == 0) {
            return 0;
        }
        if (delta > 0) {
            return delta - 1;
        }
        return delta + 65535;
    }

    public static long incrementSeqNo(long seqNo) {
        if (++seqNo > 65535L) {
            seqNo = 0L;
        }
        return seqNo;
    }

    public static Format matches(Format in, Format[] outs) {
        for (Format out : outs) {
            if (!in.matches(out)) continue;
            return out;
        }
        return null;
    }

    public static YUVFormat specialize(YUVFormat yuvFormat, Class<?> dataType) {
        int offsetV;
        int offsetU;
        int offsetY;
        int strideUV;
        Dimension size = yuvFormat.getSize();
        int strideY = yuvFormat.getStrideY();
        if (strideY == -1 && size != null) {
            strideY = size.width;
        }
        if ((strideUV = yuvFormat.getStrideUV()) == -1 && strideY != -1) {
            strideUV = (strideY + 1) / 2;
        }
        if ((offsetY = yuvFormat.getOffsetY()) == -1) {
            offsetY = 0;
        }
        if ((offsetU = yuvFormat.getOffsetU()) == -1 && strideY != -1 && size != null) {
            offsetU = offsetY + strideY * size.height;
        }
        if ((offsetV = yuvFormat.getOffsetV()) == -1 && offsetU != -1 && strideUV != -1 && size != null) {
            offsetV = offsetU + strideUV * ((size.height + 1) / 2);
        }
        int maxDataLength = strideY != -1 && strideUV != -1 && size != null ? strideY * size.height + 2 * strideUV * ((size.height + 1) / 2) + 8 : -1;
        return new YUVFormat(size, maxDataLength, dataType == null ? yuvFormat.getDataType() : dataType, yuvFormat.getFrameRate(), 2, strideY, strideUV, offsetY, offsetU, offsetV);
    }

    protected AbstractCodec2(String name, Class<? extends Format> formatClass, Format[] supportedOutputFormats) {
        this.formatClass = formatClass;
        this.name = name;
        this.supportedOutputFormats = supportedOutputFormats;
        if (this instanceof Effect) {
            this.inputFormats = this.supportedOutputFormats;
        }
    }

    @Override
    public void close() {
        if (!this.opened) {
            return;
        }
        this.doClose();
        this.opened = false;
        super.close();
    }

    protected void discardOutputBuffer(Buffer outputBuffer) {
        outputBuffer.setDiscard(true);
    }

    protected abstract void doClose();

    protected abstract void doOpen() throws ResourceUnavailableException;

    protected abstract int doProcess(Buffer var1, Buffer var2);

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        if (this instanceof Effect) {
            return new Format[]{inputFormat};
        }
        return this.supportedOutputFormats == null ? EMPTY_FORMATS : (Format[])this.supportedOutputFormats.clone();
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public Format[] getSupportedOutputFormats(Format inputFormat) {
        if (inputFormat == null) {
            return this.supportedOutputFormats;
        }
        if (!this.formatClass.isInstance(inputFormat) || AbstractCodec2.matches(inputFormat, this.inputFormats) == null) {
            return EMPTY_FORMATS;
        }
        return this.getMatchingOutputFormats(inputFormat);
    }

    @Override
    public void open() throws ResourceUnavailableException {
        if (this.opened) {
            return;
        }
        this.doOpen();
        this.opened = true;
        super.open();
    }

    @Override
    public int process(Buffer inBuf, Buffer outBuf) {
        if (!this.checkInputBuffer(inBuf)) {
            return 1;
        }
        if (this.isEOM(inBuf)) {
            this.propagateEOM(outBuf);
            return 0;
        }
        if (inBuf.isDiscard()) {
            this.discardOutputBuffer(outBuf);
            return 0;
        }
        if ((0x3000000 & this.features) == 0 && (4 & inBuf.getFlags()) != 0) {
            return 4;
        }
        return this.doProcess(inBuf, outBuf);
    }

    @Override
    public Format setInputFormat(Format format) {
        if (!this.formatClass.isInstance(format) || AbstractCodec2.matches(format, this.inputFormats) == null) {
            return null;
        }
        return super.setInputFormat(format);
    }

    @Override
    public Format setOutputFormat(Format format) {
        if (!this.formatClass.isInstance(format) || AbstractCodec2.matches(format, this.getMatchingOutputFormats(this.inputFormat)) == null) {
            return null;
        }
        return super.setOutputFormat(format);
    }

    protected void updateOutput(Buffer outputBuffer, Format format, int length, int offset) {
        outputBuffer.setFormat(format);
        outputBuffer.setLength(length);
        outputBuffer.setOffset(offset);
    }

    public static byte[] validateByteArraySize(Buffer buffer, int newSize, boolean arraycopy) {
        byte[] newBytes;
        Object data = buffer.getData();
        if (data instanceof byte[]) {
            byte[] bytes = (byte[])data;
            if (bytes.length < newSize) {
                newBytes = new byte[newSize];
                buffer.setData(newBytes);
                if (arraycopy) {
                    System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                } else {
                    buffer.setLength(0);
                    buffer.setOffset(0);
                }
            } else {
                newBytes = bytes;
            }
        } else {
            newBytes = new byte[newSize];
            buffer.setData(newBytes);
            buffer.setLength(0);
            buffer.setOffset(0);
        }
        return newBytes;
    }

    protected short[] validateShortArraySize(Buffer buffer, int newSize) {
        short[] newShorts;
        Object data = buffer.getData();
        if (data instanceof short[]) {
            short[] shorts = (short[])data;
            if (shorts.length >= newSize) {
                return shorts;
            }
            newShorts = new short[newSize];
            System.arraycopy(shorts, 0, newShorts, 0, shorts.length);
        } else {
            newShorts = new short[newSize];
            buffer.setLength(0);
            buffer.setOffset(0);
        }
        buffer.setData(newShorts);
        return newShorts;
    }
}

