/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Socket;
import org.ice4j.socket.MultiplexingSocket;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.Logger;

public class RTPConnectorTCPInputStream
extends RTPConnectorInputStream {
    private static final Logger logger = Logger.getLogger(RTPConnectorTCPInputStream.class);
    private final Socket socket;

    public RTPConnectorTCPInputStream(Socket socket) {
        this.socket = socket;
        if (socket != null) {
            try {
                socket.setReceiveBufferSize(65535);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.closed = false;
            this.receiverThread = new Thread((Runnable)((Object)this));
            this.receiverThread.start();
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void doLogPacket(DatagramPacket p) {
        if (this.socket.getLocalAddress() == null) {
            return;
        }
        if (this.socket instanceof MultiplexingSocket) {
            return;
        }
        PacketLoggingService packetLogging = LibJitsi.getPacketLoggingService();
        if (packetLogging != null) {
            byte[] byArray;
            if (p.getAddress() != null) {
                byArray = p.getAddress().getAddress();
            } else {
                byte[] byArray2 = new byte[4];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = 0;
                byArray = byArray2;
                byArray2[3] = 0;
            }
            packetLogging.logPacket(PacketLoggingService.ProtocolName.RTP, byArray, p.getPort(), this.socket.getLocalAddress().getAddress(), this.socket.getLocalPort(), PacketLoggingService.TransportName.TCP, false, p.getData(), p.getOffset(), p.getLength());
        }
    }

    protected void receivePacket(DatagramPacket p) throws IOException {
        int len = -1;
        byte[] data = null;
        try {
            data = p.getData();
            len = this.socket.getInputStream().read(data);
        }
        catch (Exception e) {
            logger.info("problem read: " + e);
        }
        if (len <= 0) {
            throw new IOException("Failed to read on TCP socket");
        }
        p.setData(data);
        p.setLength(len);
        p.setAddress(this.socket.getInetAddress());
        p.setPort(this.socket.getPort());
    }
}

