/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mathzrtp.ec;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.mathzrtp.ec.ECCurve;
import org.bouncycastle.mathzrtp.ec.ECMultiplier;
import org.bouncycastle.mathzrtp.ec.ECPoint;
import org.bouncycastle.mathzrtp.ec.PreCompInfo;
import org.bouncycastle.mathzrtp.ec.Tnaf;
import org.bouncycastle.mathzrtp.ec.WTauNafPreCompInfo;
import org.bouncycastle.mathzrtp.ec.ZTauElement;

class WTauNafMultiplier
implements ECMultiplier {
    WTauNafMultiplier() {
    }

    public ECPoint multiply(ECPoint point, BigIntegerCrypto k, PreCompInfo preCompInfo) {
        if (!(point instanceof ECPoint.F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint.F2m p = (ECPoint.F2m)point;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        int m = curve.getM();
        byte a = curve.getA().toBigInteger().byteValue();
        byte mu = curve.getMu();
        BigIntegerCrypto[] s = curve.getSi();
        ZTauElement rho = Tnaf.partModReduction(k, m, a, s, mu, (byte)10);
        return this.multiplyWTnaf(p, rho, preCompInfo, a, mu);
    }

    private ECPoint.F2m multiplyWTnaf(ECPoint.F2m p, ZTauElement lambda, PreCompInfo preCompInfo, byte a, byte mu) {
        ZTauElement[] alpha = a == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigIntegerCrypto tw = Tnaf.getTw(mu, 4);
        byte[] u = Tnaf.tauAdicWNaf(mu, lambda, (byte)4, BigIntegerCrypto.valueOf(16L), tw, alpha);
        return WTauNafMultiplier.multiplyFromWTnaf(p, u, preCompInfo);
    }

    private static ECPoint.F2m multiplyFromWTnaf(ECPoint.F2m p, byte[] u, PreCompInfo preCompInfo) {
        ECPoint.F2m[] pu;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        byte a = curve.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            pu = Tnaf.getPreComp(p, a);
            p.setPreCompInfo(new WTauNafPreCompInfo(pu));
        } else {
            pu = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        ECPoint.F2m q = (ECPoint.F2m)p.getCurve().getInfinity();
        for (int i = u.length - 1; i >= 0; --i) {
            q = Tnaf.tau(q);
            if (u[i] == 0) continue;
            q = u[i] > 0 ? q.addSimple(pu[u[i]]) : q.subtractSimple(pu[-u[i]]);
        }
        return q;
    }
}

