/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.UserSearchManager;
import net.java.sip.communicator.service.protocol.OperationSetUserSearch;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.UserSearchProviderEvent;
import net.java.sip.communicator.service.protocol.event.UserSearchProviderListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.ReportedData;

public class OperationSetUserSearchJabberImpl
implements OperationSetUserSearch,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(OperationSetUserSearchJabberImpl.class);
    private UserSearchManager searchManager = null;
    private ProtocolProviderServiceJabberImpl provider;
    private String serviceName = null;
    private Boolean userSearchEnabled = false;
    private List<UserSearchProviderListener> listeners = new ArrayList<UserSearchProviderListener>();
    private static final String USER_SEARCH_SERVICE_NAME = "USER_SEARCH_SERVICE_NAME";

    protected OperationSetUserSearchJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.provider = provider;
        this.serviceName = provider.getAccountID().getAccountPropertyString((Object)USER_SEARCH_SERVICE_NAME, "");
        if (this.serviceName.equals("")) {
            provider.addRegistrationStateChangeListener(this);
        } else {
            this.setUserSearchEnabled(true);
        }
    }

    private void setUserSearchEnabled(boolean isEnabled) {
        this.userSearchEnabled = isEnabled;
        int type = isEnabled ? UserSearchProviderEvent.PROVIDER_ADDED : UserSearchProviderEvent.PROVIDER_REMOVED;
        this.fireUserSearchProviderEvent(new UserSearchProviderEvent((ProtocolProviderService)this.provider, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserSearchProviderEvent(UserSearchProviderEvent event) {
        ArrayList<UserSearchProviderListener> tmpListeners;
        List<UserSearchProviderListener> list = this.listeners;
        synchronized (list) {
            tmpListeners = new ArrayList<UserSearchProviderListener>(this.listeners);
        }
        for (UserSearchProviderListener l : tmpListeners) {
            l.onUserSearchProviderEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
            this.discoverSearchService();
        } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
            Boolean bl = this.userSearchEnabled;
            synchronized (bl) {
                this.setUserSearchEnabled(false);
            }
        }
    }

    private void discoverSearchService() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Boolean bl = OperationSetUserSearchJabberImpl.this.userSearchEnabled;
                synchronized (bl) {
                    List<String> serviceNames = UserSearchManager.getAvailableServiceNames(OperationSetUserSearchJabberImpl.this.provider);
                    if (!serviceNames.isEmpty()) {
                        OperationSetUserSearchJabberImpl.this.serviceName = serviceNames.get(0);
                        OperationSetUserSearchJabberImpl.this.setUserSearchEnabled(true);
                    } else {
                        OperationSetUserSearchJabberImpl.this.setUserSearchEnabled(false);
                    }
                }
            }
        }.start();
    }

    public void createSearchManager() {
        if (this.searchManager == null) {
            this.searchManager = new UserSearchManager((Connection)this.provider.getConnection(), this.serviceName);
        }
    }

    public void removeSearchManager() {
        this.searchManager = null;
    }

    public List<String> search(String searchedString) {
        ReportedData data = null;
        try {
            data = this.searchManager.searchForString(searchedString);
        }
        catch (XMPPException e) {
            logger.error((Object)e);
            return null;
        }
        if (data == null) {
            logger.error((Object)"No data have been received from server.");
            return null;
        }
        Iterator columns = data.getColumns();
        Iterator rows = data.getRows();
        if (columns == null || rows == null) {
            logger.error((Object)"The received data is corrupted.");
            return null;
        }
        ReportedData.Column jidColumn = null;
        while (columns.hasNext()) {
            ReportedData.Column tmpCollumn = (ReportedData.Column)columns.next();
            if (!tmpCollumn.getType().equals("jid-single")) continue;
            jidColumn = tmpCollumn;
            break;
        }
        if (jidColumn == null) {
            logger.error((Object)"No jid collumn provided by the server.");
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        while (rows.hasNext()) {
            ReportedData.Row row = (ReportedData.Row)rows.next();
            result.add((String)row.getValues(jidColumn.getVariable()).next());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserSearchProviderListener(UserSearchProviderListener l) {
        List<UserSearchProviderListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserSearchProviderListener(UserSearchProviderListener l) {
        List<UserSearchProviderListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public boolean isEnabled() {
        return this.userSearchEnabled;
    }
}

