/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osgi.framework.launch;

import java.util.EventListener;
import java.util.EventObject;
import java.util.concurrent.RejectedExecutionException;
import net.java.sip.communicator.impl.osgi.framework.AsyncExecutor;
import net.java.sip.communicator.impl.osgi.framework.launch.EventListenerList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher {
    private final AsyncExecutor<Command> executor = new AsyncExecutor();
    private final EventListenerList listeners = new EventListenerList();

    public <T extends EventListener> boolean addListener(Bundle bundle, Class<T> clazz, T t) {
        return this.listeners.add(bundle, clazz, t);
    }

    void fireBundleEvent(BundleEvent bundleEvent) {
        this.fireEvent(BundleListener.class, (EventObject)bundleEvent);
    }

    private <T extends EventListener> void fireEvent(Class<T> clazz, EventObject eventObject) {
        EventListener[] eventListenerArray = this.listeners.getListeners(clazz);
        if (eventListenerArray.length != 0) {
            try {
                this.executor.execute(new Command(this, clazz, eventListenerArray, eventObject));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    void fireServiceEvent(ServiceEvent serviceEvent) {
        this.fireEvent(ServiceListener.class, (EventObject)serviceEvent);
    }

    public <T extends EventListener> boolean removeListener(Bundle bundle, Class<T> clazz, T t) {
        return this.listeners.remove(bundle, clazz, t);
    }

    public boolean removeListeners(Bundle bundle) {
        return this.listeners.removeAll(bundle);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Command
    implements Runnable {
        private final Class<? extends EventListener> clazz;
        private final EventObject event;
        private final EventListener[] listeners;
        final /* synthetic */ EventDispatcher this$0;

        public <T extends EventListener> Command(Class<T> clazz, T[] TArray, EventObject eventObject) {
            this.this$0 = var1_1;
            this.clazz = clazz;
            this.listeners = TArray;
            this.event = eventObject;
        }

        @Override
        public void run() {
            for (EventListener eventListener : this.listeners) {
                try {
                    if (BundleListener.class.equals(this.clazz)) {
                        ((BundleListener)eventListener).bundleChanged((BundleEvent)this.event);
                        continue;
                    }
                    if (!ServiceListener.class.equals(this.clazz)) continue;
                    ((ServiceListener)eventListener).serviceChanged((ServiceEvent)this.event);
                }
                catch (Throwable throwable) {
                    if (FrameworkListener.class.equals(this.clazz) && ((FrameworkEvent)this.event).getType() == 2) continue;
                }
            }
        }
    }
}

