/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osgi.framework;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncExecutor<T extends Runnable> {
    private long keepAliveTime;
    private final List<CommandFuture<T>> queue = new LinkedList<CommandFuture<T>>();
    private boolean shutdown;
    private boolean shutdownNow;
    private Thread thread;

    public AsyncExecutor() {
        this(0L, TimeUnit.MILLISECONDS);
    }

    public AsyncExecutor(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException("keepAliveTime");
        }
        this.keepAliveTime = timeUnit.toMillis(l);
    }

    private synchronized boolean contains(T t) {
        for (CommandFuture<T> commandFuture : this.queue) {
            if (commandFuture.command != t) continue;
            return true;
        }
        return false;
    }

    public void execute(T t) {
        this.submit(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread() {
        long l = -1L;
        while (true) {
            CommandFuture<T> commandFuture;
            AsyncExecutor<T> asyncExecutor = this;
            synchronized (asyncExecutor) {
                if (this.shutdownNow) {
                    return;
                }
                if (this.queue.isEmpty()) {
                    if (l == -1L) {
                        l = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - l > this.keepAliveTime) {
                        return;
                    }
                    boolean bl = false;
                    try {
                        this.wait(this.keepAliveTime);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                l = -1L;
                commandFuture = this.queue.remove(0);
            }
            asyncExecutor = commandFuture.command;
            Throwable throwable = null;
            try {
                asyncExecutor.run();
                commandFuture.setDone(throwable == null ? Boolean.TRUE : throwable);
                continue;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    if (throwable2 instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable2;
                    }
                    this.uncaughtException(asyncExecutor, throwable2);
                    commandFuture.setDone(throwable == null ? Boolean.TRUE : throwable);
                    continue;
                }
                catch (Throwable throwable3) {
                    commandFuture.setDone(throwable == null ? Boolean.TRUE : throwable);
                    throw throwable3;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException("keepAliveTime");
        }
        AsyncExecutor asyncExecutor = this;
        synchronized (asyncExecutor) {
            this.keepAliveTime = timeUnit.toMillis(l);
            this.notifyAll();
        }
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> shutdownNow() {
        ArrayList<CommandFuture<T>> arrayList;
        Object object = this;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownNow = true;
            this.notifyAll();
            boolean bl = false;
            while (this.thread != null) {
                try {
                    this.wait(this.keepAliveTime);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            arrayList = new ArrayList<CommandFuture<T>>(this.queue.size());
            arrayList.addAll(this.queue);
        }
        object = new ArrayList(arrayList.size());
        for (CommandFuture commandFuture : arrayList) {
            object.add(commandFuture.command);
            commandFuture.setDone(Boolean.FALSE);
        }
        return object;
    }

    public synchronized Future<?> submit(T t) {
        if (t == null) {
            throw new NullPointerException("command");
        }
        if (this.shutdown) {
            throw new RejectedExecutionException("shutdown");
        }
        if (this.contains(t)) {
            throw new RejectedExecutionException("contains");
        }
        CommandFuture<T> commandFuture = new CommandFuture<T>(t);
        this.queue.add(commandFuture);
        this.startThreadOrNotifyAll();
        return commandFuture;
    }

    private synchronized void startThreadOrNotifyAll() {
        if (!(this.thread != null || this.shutdown || this.shutdownNow || this.queue.isEmpty())) {
            this.thread = new Thread(this.getClass().getName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AsyncExecutor.this.runInThread();
                    }
                    finally {
                        AsyncExecutor asyncExecutor = AsyncExecutor.this;
                        synchronized (asyncExecutor) {
                            if (Thread.currentThread().equals(AsyncExecutor.this.thread)) {
                                AsyncExecutor.this.thread = null;
                                AsyncExecutor.this.startThreadOrNotifyAll();
                            }
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notifyAll();
        }
    }

    protected void uncaughtException(T t, Throwable throwable) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandFuture<T extends Runnable>
    implements Future<Object> {
        public final T command;
        private Boolean done;
        private Throwable exception;

        public CommandFuture(T t) {
            this.command = t;
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public Object get() throws ExecutionException, InterruptedException {
            try {
                return this.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw new RuntimeException(timeoutException);
            }
        }

        @Override
        public synchronized Object get(long l, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
            l = timeUnit.toMillis(l);
            boolean bl = false;
            while (true) {
                if (this.done != null) {
                    if (this.done.booleanValue()) break;
                    throw new CancellationException();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                if (bl) {
                    throw new TimeoutException();
                }
                this.wait(l);
                bl = l != 0L;
            }
            return null;
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.done != null && this.done == false;
        }

        @Override
        public synchronized boolean isDone() {
            return this.done != null || this.exception != null;
        }

        synchronized void setDone(Object object) {
            if (object instanceof Boolean) {
                this.done = (Boolean)object;
            } else if (object instanceof Throwable) {
                this.exception = (Throwable)object;
            } else {
                throw new IllegalArgumentException("done");
            }
            this.notifyAll();
        }
    }
}

