/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Antlib;
import org.apache.tools.ant.taskdefs.DefBase;
import org.apache.tools.ant.types.EnumeratedAttribute;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Definer
extends DefBase {
    private static ResourceStack resourceStack = new ResourceStack();
    private String name;
    private String classname;
    private File file;
    private String resource;
    private int format;
    private boolean definerSet;
    private int onError;
    private String adapter;
    private String adaptTo;
    private Class adapterClass;
    private Class adaptToClass;

    public void setOnError(OnError onError) {
        this.onError = onError.getIndex();
    }

    public void setFormat(Format format) {
        this.format = format.getIndex();
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        URL uRL;
        ClassLoader classLoader = this.createLoader();
        if (!this.definerSet) {
            throw new BuildException("name, file or resource attribute of " + this.getTaskName() + " is undefined", this.getLocation());
        }
        if (this.name != null) {
            if (this.classname == null) {
                throw new BuildException("classname attribute of " + this.getTaskName() + " element is undefined", this.getLocation());
            }
            this.addDefinition(classLoader, this.name, this.classname);
            return;
        }
        if (this.classname != null) {
            String string = "You must not specify classname together with file or resource.";
            throw new BuildException(string, this.getLocation());
        }
        Enumeration enumeration = null;
        if (this.file != null) {
            uRL = this.fileToURL();
            if (uRL == null) {
                return;
            }
            enumeration = new Enumeration(){
                private boolean more;

                public final boolean hasMoreElements() {
                    return this.more;
                }

                public final Object nextElement() throws NoSuchElementException {
                    if (this.more) {
                        this.more = false;
                        return uRL;
                    }
                    throw new NoSuchElementException();
                }

                private final /* synthetic */ void this() {
                    this.more = true;
                }
                {
                    this.this();
                }
            };
        } else {
            enumeration = this.resourceToURLs(classLoader);
        }
        while (enumeration.hasMoreElements()) {
            Object var6_6;
            uRL = (URL)enumeration.nextElement();
            int n = this.format;
            if (uRL.toString().toLowerCase(Locale.US).endsWith(".xml")) {
                n = 1;
            }
            if (n == 0) {
                this.loadProperties(classLoader, uRL);
                return;
            }
            if (resourceStack.getStack().get(uRL) != null) {
                this.log("Warning: Recursive loading of " + uRL + " ignored at " + this.getLocation() + " originally loaded at " + resourceStack.getStack().get(uRL), 1);
                continue;
            }
            try {
                resourceStack.getStack().put(uRL, this.getLocation());
                this.loadAntlib(classLoader, uRL);
            }
            catch (Throwable throwable) {
                var6_6 = null;
                resourceStack.getStack().remove(uRL);
                throw throwable;
            }
            {
                var6_6 = null;
                resourceStack.getStack().remove(uRL);
            }
        }
        return;
    }

    private final URL fileToURL() {
        if (!this.file.exists()) {
            this.log("File " + this.file + " does not exist", 1);
            return null;
        }
        if (!this.file.isFile()) {
            this.log("File " + this.file + " is not a file", 1);
            return null;
        }
        try {
            return this.file.toURL();
        }
        catch (Exception exception) {
            this.log("File " + this.file + " cannot use as URL: " + exception.toString(), 1);
            return null;
        }
    }

    private final Enumeration resourceToURLs(ClassLoader classLoader) {
        Enumeration<URL> enumeration;
        try {
            enumeration = classLoader.getResources(this.resource);
        }
        catch (IOException iOException) {
            throw new BuildException("Could not fetch resources named " + this.resource, iOException, this.getLocation());
        }
        if (!enumeration.hasMoreElements() && this.onError != 2) {
            this.log("Could not load definitions from resource " + this.resource + ". It could not be found.", 1);
        }
        return enumeration;
    }

    /*
     * Exception decompiling
     */
    protected void loadProperties(ClassLoader var1_1, URL var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 154->158)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void loadAntlib(ClassLoader classLoader, URL uRL) {
        try {
            Antlib antlib = Antlib.createAntlib(this.getProject(), uRL, this.getURI());
            antlib.setClassLoader(classLoader);
            antlib.setURI(this.getURI());
            antlib.perform();
        }
        catch (BuildException buildException) {
            throw ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
        }
    }

    public void setFile(File file) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.file = file;
    }

    public void setResource(String string) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.resource = string;
    }

    public void setName(String string) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.name = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public void setAdapter(String string) {
        this.adapter = string;
    }

    protected void setAdapterClass(Class clazz) {
        this.adapterClass = clazz;
    }

    public void setAdaptTo(String string) {
        this.adaptTo = string;
    }

    protected void setAdaptToClass(Class clazz) {
        this.adaptToClass = clazz;
    }

    protected void addDefinition(ClassLoader classLoader, String string, String string2) throws BuildException {
        Class<?> clazz = null;
        try {
            try {
                string = ProjectHelper.genComponentName(this.getURI(), string);
                if (this.onError != 2) {
                    clazz = Class.forName(string2, true, classLoader);
                }
                if (this.adapter != null) {
                    this.adapterClass = Class.forName(this.adapter, true, classLoader);
                }
                if (this.adaptTo != null) {
                    this.adaptToClass = Class.forName(this.adaptTo, true, classLoader);
                }
                AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
                antTypeDefinition.setName(string);
                antTypeDefinition.setClassName(string2);
                antTypeDefinition.setClass(clazz);
                antTypeDefinition.setAdapterClass(this.adapterClass);
                antTypeDefinition.setAdaptToClass(this.adaptToClass);
                antTypeDefinition.setClassLoader(classLoader);
                if (clazz != null) {
                    antTypeDefinition.checkClass(this.getProject());
                }
                ComponentHelper.getComponentHelper(this.getProject()).addDataTypeDefinition(antTypeDefinition);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = this.getTaskName() + " class " + string2 + " cannot be found";
                throw new BuildException(string3, classNotFoundException, this.getLocation());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string4 = this.getTaskName() + " A class needed by class " + string2 + " cannot be found: " + noClassDefFoundError.getMessage();
                throw new BuildException(string4, noClassDefFoundError, this.getLocation());
            }
        }
        catch (BuildException buildException) {
            switch (this.onError) {
                case 0: {
                    throw buildException;
                }
                case 1: {
                    this.log(buildException.getLocation() + "Warning: " + buildException.getMessage(), 1);
                    break;
                }
                default: {
                    this.log(buildException.getLocation() + buildException.getMessage(), 4);
                }
            }
        }
    }

    private final void tooManyDefinitions() {
        throw new BuildException("Only one of the attributes name,file,resource can be set", this.getLocation());
    }

    private final /* synthetic */ void this() {
        this.format = 0;
        this.definerSet = false;
        this.onError = 0;
    }

    public Definer() {
        this.this();
    }

    public static class OnError
    extends EnumeratedAttribute {
        public static final int FAIL = 0;
        public static final int REPORT = 1;
        public static final int IGNORE = 2;

        public String[] getValues() {
            return new String[]{"fail", "report", "ignore"};
        }

        public OnError() {
        }

        public OnError(String string) {
            this.setValue(string);
        }
    }

    public static class Format
    extends EnumeratedAttribute {
        public static final int PROPERTIES = 0;
        public static final int XML = 1;

        public String[] getValues() {
            return new String[]{"properties", "xml"};
        }
    }

    private static class ResourceStack
    extends ThreadLocal {
        public Object initialValue() {
            return new HashMap();
        }

        Map getStack() {
            return (Map)this.get();
        }

        private ResourceStack() {
        }
    }
}

