/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class MatchAllDocsQuery
extends Query {
    protected Weight createWeight(Searcher searcher) {
        return new MatchAllDocsWeight(searcher);
    }

    public void extractTerms(Set terms) {
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MatchAllDocsQuery");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MatchAllDocsQuery)) {
            return false;
        }
        MatchAllDocsQuery other = (MatchAllDocsQuery)o;
        return this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ 0x1AA71190;
    }

    private class MatchAllDocsWeight
    implements Weight {
        private Searcher searcher;
        private float queryWeight;
        private float queryNorm;

        public MatchAllDocsWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public String toString() {
            return "weight(" + MatchAllDocsQuery.this + ")";
        }

        public Query getQuery() {
            return MatchAllDocsQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() {
            this.queryWeight = MatchAllDocsQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader) {
            return new MatchAllScorer(reader, MatchAllDocsQuery.this.getSimilarity(this.searcher), this);
        }

        public Explanation explain(IndexReader reader, int doc) {
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("MatchAllDocsQuery, product of:");
            queryExpl.setValue(this.getValue());
            if (MatchAllDocsQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(new Explanation(MatchAllDocsQuery.this.getBoost(), "boost"));
            }
            queryExpl.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            return queryExpl;
        }
    }

    private class MatchAllScorer
    extends Scorer {
        final IndexReader reader;
        int id;
        final int maxId;
        final float score;

        MatchAllScorer(IndexReader reader, Similarity similarity, Weight w) {
            super(similarity);
            this.reader = reader;
            this.id = -1;
            this.maxId = reader.maxDoc() - 1;
            this.score = w.getValue();
        }

        public Explanation explain(int doc) {
            return null;
        }

        public int doc() {
            return this.id;
        }

        public boolean next() {
            while (this.id < this.maxId) {
                ++this.id;
                if (this.reader.isDeleted(this.id)) continue;
                return true;
            }
            return false;
        }

        public float score() {
            return this.score;
        }

        public boolean skipTo(int target) {
            this.id = target - 1;
            return this.next();
        }
    }
}

