/**
 * $RCSfile$
 * $Revision: $
 * $Date: $
 *
 * Copyright (C) 2008 Jive Software. All rights reserved.
 *
 * This software is published under the terms of the GNU Public License (GPL),
 * a copy of which is included in this distribution.
 */

package org.jivesoftware.openfire.component;

import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.IQ;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * Task that will be executed on other cluster nodes to trigger the event that a component has
 * send its disco#info to the server.
 *
 * @author Gaston Dombiak
 */
public class NotifyComponentInfo implements ClusterTask {
    private IQ iq;

    public NotifyComponentInfo() {
    }

    public NotifyComponentInfo(IQ iq) {
        this.iq = iq;
    }

    public Object getResult() {
        return null;
    }

    public void run() {
        final InternalComponentManager manager = InternalComponentManager.getInstance();
        manager.addComponentInfo(iq);
        manager.notifyComponentInfo(iq);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSerializable(out, (DefaultElement) iq.getElement());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Element packetElement = (Element) ExternalizableUtil.getInstance().readSerializable(in);
        iq = new IQ(packetElement, true);
    }
}
