/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.txn;

import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.txn.CollectionTxnAddBackupOperation;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CollectionTxnAddOperation
extends CollectionBackupAwareOperation {
    private long itemId;
    private Data value;

    public CollectionTxnAddOperation() {
    }

    public CollectionTxnAddOperation(String name, long itemId, Data value) {
        super(name);
        this.itemId = itemId;
        this.value = value;
    }

    @Override
    public boolean shouldBackup() {
        return false;
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionTxnAddBackupOperation(this.name, this.itemId, this.value);
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.getOrCreateContainer().commitAdd(this.itemId, this.value);
        this.response = true;
    }

    @Override
    public void afterRun() throws Exception {
        this.publishEvent(ItemEventType.ADDED, this.value);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.value = new Data();
        this.value.readData(in);
    }
}

