/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import rath.msnm.AbstractProcessor;
import rath.msnm.Debug;
import rath.msnm.MSNMessenger;
import rath.msnm.entity.Callback;
import rath.msnm.entity.MsnFriend;
import rath.msnm.entity.ServerInfo;
import rath.msnm.ftp.FileMessageProcessor;
import rath.msnm.ftp.ToSendFile;
import rath.msnm.msg.FileTransferMessage;
import rath.msnm.msg.IncomingMessage;
import rath.msnm.msg.MimeMessage;
import rath.msnm.msg.OutgoingMessage;

public class SwitchboardSession
extends AbstractProcessor {
    private static int timeout = 180000;
    private FileMessageProcessor file = null;
    private String sessionId = null;
    private String cookie = null;
    private HashMap friendMap = new HashMap();
    private MsnFriend lastFriend = null;
    private String targetLoginName = null;
    private HashMap slpMessageMap = new HashMap();
    private HashMap slpDataMap = new HashMap();
    private Object userObject = null;

    public SwitchboardSession(MSNMessenger msn, ServerInfo info, String sessionId) {
        super(msn, info, 1);
        this.setServerName("SS");
        this.setAutoOutSend(true);
        this.sessionId = sessionId;
        this.file = new FileMessageProcessor(this);
    }

    public void setUserObject(Object o) {
        this.userObject = o;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    protected void sessionOpened() {
    }

    public void setTarget(String loginName) {
        this.targetLoginName = loginName;
    }

    public String getTarget() {
        return this.targetLoginName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    protected void makeConnection() throws IOException {
        super.makeConnection();
        this.setTimeout(timeout);
    }

    public void setTimeout(int timeout) {
        SwitchboardSession.timeout = timeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(timeout);
            }
            catch (IOException e) {
                System.err.println("can't assign SO_TIMEOUT value");
            }
        }
    }

    public int getTimeout() {
        return timeout;
    }

    public void init() throws IOException {
        Callback cb = Callback.getInstance("processRosterInfo", this.getClass());
        cb.setInfinite();
        OutgoingMessage out = new OutgoingMessage("ANS");
        this.markTransactionId(out);
        out.add(this.msn.getLoginName());
        out.add(this.cookie);
        out.add(this.sessionId);
        out.setBackProcess(cb);
        this.sendMessage(out);
    }

    protected void addMsnFriend(MsnFriend friend) {
        this.friendMap.put(friend.getLoginName(), friend);
        this.lastFriend = friend;
    }

    public MsnFriend getMsnFriend() {
        return this.lastFriend;
    }

    public boolean isInFriend(String loginName) {
        return this.friendMap.containsKey(loginName);
    }

    protected MsnFriend removeMsnFriend(String loginName) {
        return (MsnFriend)this.friendMap.remove(loginName);
    }

    public Collection getMsnFriends() {
        return this.friendMap.values();
    }

    public int getFriendCount() {
        return this.friendMap.size();
    }

    protected void processMimeMessage(IncomingMessage msg) throws Exception {
        int len = msg.getInt(2);
        int readlen = 0;
        byte[] b = new byte[len];
        for (int off = 0; off < len && (readlen = this.in.read(b, off, len - off)) != -1; off += readlen) {
        }
        MimeMessage mime = MimeMessage.parse(b);
        if (Debug.printMime) {
            System.out.println(new String(b, "UTF-8"));
        }
        int kind = mime.getKind();
        switch (kind) {
            case 1: {
                this.processTypingUser(msg, mime);
                break;
            }
            case 2: {
                this.processInstantMessage(msg, mime);
                break;
            }
            case 3: {
                this.file.processMessage(msg, mime);
                break;
            }
        }
    }

    protected void processWhoJoined(IncomingMessage msg) throws Exception {
        String loginName = msg.get(0);
        String friendlyName = msg.get(1);
        MsnFriend friend = this.msn.getBuddyGroup().getAllowList().get(loginName);
        if (friend == null) {
            friend = new MsnFriend(loginName, friendlyName);
        }
        friend.setFriendlyName(friendlyName);
        this.addMsnFriend(friend);
        this.msn.fireJoinSessionEvent(this, friend);
    }

    public void processNotifyMessage(IncomingMessage msg) throws Exception {
        String header = msg.getHeader();
        if (header.equals("MSG")) {
            this.processMimeMessage(msg);
        } else if (header.equals("JOI")) {
            this.processWhoJoined(msg);
        } else if (header.equals("BYE")) {
            String partLoginName = msg.get(0);
            MsnFriend parter = this.removeMsnFriend(partLoginName);
            if (parter != null) {
                this.msn.firePartSessionEvent(this, parter);
            }
            if (this.friendMap.size() == 0) {
                this.isLive = false;
            }
        }
    }

    public void cleanUp() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.friendMap.clear();
        if (this.sessionId != null) {
            this.msn.fireSwitchboardSessionEndedEvent(this);
        }
    }

    public void close() throws IOException {
        this.isLive = false;
        OutgoingMessage out = new OutgoingMessage("OUT");
        this.sendMessage(out);
        this.interrupt();
    }

    public void processRosterInfo(IncomingMessage msg) throws IOException {
        String header = msg.getHeader();
        if (header.equals("IRO")) {
            String destLoginName = msg.get(2);
            String destFriendlyName = msg.get(3);
            MsnFriend friend = this.msn.getBuddyGroup().getAllowList().get(destLoginName);
            if (friend != null) {
                friend.setFriendlyName(destFriendlyName);
                this.addMsnFriend(friend);
            } else {
                System.err.println("* Not found in allow list: " + destLoginName);
                this.addMsnFriend(new MsnFriend(destLoginName, destFriendlyName));
            }
        } else if (header.equals("ANS")) {
            this.removeInfiniteTransactionId(msg.getTransactionId());
            String returnCode = msg.get(0);
            if (returnCode.equals("OK")) {
                this.msn.fireSwitchboardSessionStartedEvent(this);
                this.sessionOpened();
            }
        }
    }

    protected void processTypingUser(IncomingMessage msg, MimeMessage mime) throws IOException {
        MsnFriend friend = new MsnFriend(msg.get(0), msg.get(1));
        this.msn.fireProgressTypingEvent(this, friend, mime.getProperty("TypingUser"));
    }

    protected void processInstantMessage(IncomingMessage msg, MimeMessage mime) throws IOException {
        MsnFriend friend = new MsnFriend(msg.get(0));
        friend.setFriendlyName(msg.get(1));
        this.msn.fireInstantMessageEvent(this, friend, mime);
    }

    public void sendMessage(MimeMessage mime) throws IOException {
        OutgoingMessage out = new OutgoingMessage("MSG");
        this.markTransactionId(out);
        out.add("N");
        this.sendMimeMessage(out, mime);
    }

    public void sendFileRequest(ToSendFile file, FileTransferMessage mime) throws IOException {
        this.file.registerSend(file);
        this.sendMessage(mime);
    }

    public void acceptFileReceive(int cookie, File toReceive) throws IOException {
        this.file.registerReceive(cookie, toReceive);
        this.sendMessage(FileTransferMessage.createAcceptMessage(cookie));
    }

    public void rejectFileReceive(int cookie) throws IOException {
        this.sendMessage(FileTransferMessage.createRejectMessage(cookie));
    }

    public void sendTypingMessage(MimeMessage mime) throws IOException {
        mime.setKind(1);
        this.sendMessage(mime);
    }

    public void sendInstantMessage(MimeMessage mime) throws IOException {
        mime.setKind(2);
        this.sendMessage(mime);
    }

    public void inviteFriend(String loginName) throws IOException {
        OutgoingMessage out = new OutgoingMessage("CAL");
        this.markTransactionId(out);
        out.add(loginName);
        this.sendMessage(out);
    }

    public void processError(Throwable e) {
        if (!(e instanceof IOException)) {
            e.printStackTrace();
        }
    }

    public MsnFriend getOwner() {
        return this.msn.getOwner();
    }

    public MsnFriend getLastFriend() {
        return this.lastFriend;
    }
}

