/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientReadyCmd
extends ConnCommand {
    private final List<SnacFamilyInfo> infos;

    protected ClientReadyCmd(SnacPacket snacPacket) {
        super(2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        int n = byteBlock.getLength() / 8;
        ArrayList<SnacFamilyInfo> arrayList = new ArrayList<SnacFamilyInfo>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(SnacFamilyInfo.readSnacFamilyInfo(byteBlock));
            byteBlock = byteBlock.subBlock(8);
        }
        this.infos = DefensiveTools.getUnmodifiable(arrayList);
    }

    public ClientReadyCmd(Collection<SnacFamilyInfo> collection) {
        super(2);
        this.infos = DefensiveTools.getSafeListCopy(collection, "infos");
    }

    public final List<SnacFamilyInfo> getSnacFamilyInfos() {
        return this.infos;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.infos != null) {
            for (SnacFamilyInfo snacFamilyInfo : this.infos) {
                snacFamilyInfo.write(outputStream);
            }
        }
    }

    public String toString() {
        return "ClientReadyCmd: " + this.infos;
    }
}

