/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.rvcmd.AbstractRvCmd;
import net.kano.joscar.rvcmd.RejectRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;

public abstract class AbstractRejectRvCmd
extends AbstractRvCmd
implements RejectRvCmd {
    private static final int TYPE_REJECTCODE = 11;
    private final int rejectCode;

    protected AbstractRejectRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        MutableTlvChain mutableTlvChain = this.getMutableTlvs();
        this.rejectCode = mutableTlvChain.getUShort(11);
        mutableTlvChain.removeTlvs(new int[]{11});
    }

    protected AbstractRejectRvCmd(CapabilityBlock capabilityBlock, int n) {
        super(1, capabilityBlock);
        DefensiveTools.checkRange(n, "rejectionCode", -1);
        this.rejectCode = n;
    }

    public final int getRejectCode() {
        return this.rejectCode;
    }

    protected final void writeHeaderRvTlvs(OutputStream outputStream) throws IOException {
        if (this.rejectCode != -1) {
            Tlv.getUShortInstance(11, this.rejectCode).write(outputStream);
        }
    }

    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": rejectCode=" + this.rejectCode;
    }
}

