/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.DoubleProbe;
import com.hazelcast.internal.metrics.LongProbe;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.util.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public final class OperatingSystemMetricsSet {
    private static final double PERCENTAGE_MULTIPLIER = 100.0;

    private OperatingSystemMetricsSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getCommittedVirtualMemorySize", "os.committedVirtualMemorySize");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getFreePhysicalMemorySize", "os.freePhysicalMemorySize");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getFreeSwapSpaceSize", "os.freeSwapSpaceSize");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getProcessCpuTime", "os.processCpuTime");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getTotalPhysicalMemorySize", "os.totalPhysicalMemorySize");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getTotalSwapSpaceSize", "os.totalSwapSpaceSize");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getMaxFileDescriptorCount", "os.maxFileDescriptorCount");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getOpenFileDescriptorCount", "os.openFileDescriptorCount");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getProcessCpuLoad", "os.processCpuLoad");
        OperatingSystemMetricsSet.registerMethod(metricsRegistry, mxBean, "getSystemCpuLoad", "os.systemCpuLoad");
        metricsRegistry.register(mxBean, "os.systemLoadAverage", new DoubleProbe<OperatingSystemMXBean>(){

            @Override
            public double get(OperatingSystemMXBean bean) {
                return 100.0 * bean.getSystemLoadAverage();
            }
        });
    }

    static void registerMethod(MetricsRegistry metricsRegistry, Object osBean, String methodName, String name) {
        final Method method = OperatingSystemMetricsSet.getMethod(osBean, methodName);
        if (method == null) {
            return;
        }
        if (Long.TYPE.equals(method.getReturnType())) {
            metricsRegistry.register(osBean, name, new LongProbe(){

                public long get(Object bean) throws Exception {
                    return (Long)method.invoke(bean, new Object[0]);
                }
            });
        } else {
            metricsRegistry.register(osBean, name, new DoubleProbe(){

                public double get(Object bean) throws Exception {
                    return (Double)method.invoke(bean, new Object[0]);
                }
            });
        }
    }

    private static Method getMethod(Object source, String methodName) {
        try {
            Method method = source.getClass().getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }
}

