/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.ParseException;
import java.util.NoSuchElementException;
import org.hn.sleek.jmml.IncomingMessage;
import org.hn.sleek.jmml.MSNPListener;
import org.hn.sleek.jmml.OutgoingMessage;

public class ServerConnection {
    static final int SWITCHBOARD_CONNECTION = 0;
    static final int DISPATCH_CONNECTION = 1;
    static final int NOTIFICATION_CONNECTION = 2;
    Socket connection;
    MSNPListener listener;
    boolean connected = false;

    public ServerConnection(String serverAddress, int port, MSNPListener listener) {
        this.listener = listener;
        try {
            this.connection = new Socket(serverAddress, port);
            this.connected = true;
        }
        catch (IOException e) {
            this.disconnect(true);
            return;
        }
        System.out.println("Connecting... " + serverAddress + ":" + port);
        this.readLoop();
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    synchronized void disconnect(boolean bCallListener) {
        if (this.isConnected()) {
            System.err.println("ServerConnection.disconnect() - Processing disconnect");
            try {
                this.connected = false;
                if (bCallListener) {
                    System.err.println("ServerConnection.disconnect() - Dispatching disconnect event throught MSNPListener objects");
                    this.listener.serverDisconnected();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (IOException e) {
                System.err.println("ServerConnection.disconnect() - " + e);
            }
        }
    }

    public void sendMSNPMessage(OutgoingMessage msg) {
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.connection.getOutputStream(), "UTF-8"));
            pw.write(msg.getMessageString());
            pw.flush();
            System.out.println(">>> " + msg.toString().trim());
        }
        catch (Exception e) {
            System.out.println("ServerConnection.sendMSNPMessage() - " + e);
        }
    }

    private void readLoop() {
        Thread readThread = new Thread(){

            public void run() {
                BufferedReader br;
                try {
                    br = new BufferedReader(new InputStreamReader(ServerConnection.this.connection.getInputStream(), "UTF-8"));
                }
                catch (IOException e) {
                    ServerConnection.this.disconnect(true);
                    return;
                }
                while (ServerConnection.this.connected) {
                    IncomingMessage msg;
                    try {
                        String inputLine = br.readLine();
                        System.out.println("<<< " + inputLine);
                        if (inputLine == null) break;
                        msg = IncomingMessage.parseMessage(inputLine);
                    }
                    catch (IOException e) {
                        System.err.println("1-ServerConnection.readLoop() - " + e);
                        break;
                    }
                    catch (ParseException e) {
                        System.err.println("2-ServerConnection.readLoop() - " + e);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        System.err.println("3-ServerConnection.readLoop() - " + e);
                        continue;
                    }
                    if (msg.hasBody()) {
                        try {
                            int length = msg.getBodyLength();
                            char[] body = new char[length];
                            br.read(body, 0, length);
                            msg.setBody(new String(body));
                        }
                        catch (NoSuchFieldException e) {
                            System.err.println("4-ServerConnection.readLoop() - " + e);
                        }
                        catch (IOException e) {
                            System.err.println("5-ServerConnection.readLoop() - " + e);
                        }
                    }
                    new HandleMessage(msg).run();
                }
                ServerConnection.this.disconnect(true);
            }
        };
        readThread.start();
    }

    class HandleMessage
    extends Thread {
        IncomingMessage msg;

        public HandleMessage(IncomingMessage msg) {
            this.msg = msg;
        }

        public void run() {
            ServerConnection.this.listener.incomingMSNPMessage(this.msg);
        }
    }
}

