/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.acct.AcctInfoCmd;
import net.kano.joscar.snaccmd.acct.AcctModAck;
import net.kano.joscar.snaccmd.acct.ConfirmAck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAcctCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(7, 5), new CmdType(7, 7), new CmdType(7, 3));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 7) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 5) {
            return new AcctModAck(snacPacket);
        }
        if (n == 7) {
            return new ConfirmAck(snacPacket);
        }
        if (n == 3) {
            return new AcctInfoCmd(snacPacket);
        }
        return null;
    }
}

