/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import org.jetbrains.annotations.Nullable;

public final class WarningLevel
extends Number {
    private static final WarningLevel LEVEL_ZERO = new WarningLevel(0);
    private static final WarningLevel LEVEL_999 = new WarningLevel(999);
    private final float fv;
    private final int rv;
    private final int orig;

    @Nullable
    public static WarningLevel getInstanceFromX10(int n) {
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return LEVEL_ZERO;
        }
        if (n == 999) {
            return LEVEL_999;
        }
        return new WarningLevel(n);
    }

    public static WarningLevel getInstanceFromPercent(int n) {
        return WarningLevel.getInstanceFromX10(n * 10);
    }

    private WarningLevel(int n) {
        this.orig = n;
        this.fv = (float)n / 10.0f;
        this.rv = Math.round(this.fv);
    }

    public double doubleValue() {
        return this.fv;
    }

    public float floatValue() {
        return this.fv;
    }

    public int intValue() {
        return this.rv;
    }

    public long longValue() {
        return this.rv;
    }

    public int getX10Value() {
        return this.orig;
    }

    public String toString() {
        return this.intValue() + "." + this.getX10Value() % 10 + "%";
    }
}

