/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.addins;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class AddinsReqRvCmd
extends AbstractRequestRvCmd {
    public static final int CODE_DEFAULT = 0;
    public static final long FLAGS_DEFAULT = 0L;
    private static final int TYPE_ADDINURI = 7;
    private final int code;
    private final String addinUri;
    private final ByteBlock uuid;
    private final String addinName;
    private final String computerName;
    private final long flags;
    private final InvitationMessage invMessage;

    public AddinsReqRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.addinUri = tlvChain.getString(7);
        ByteBlock byteBlock = this.getServiceData();
        int n = -1;
        ByteBlock byteBlock2 = null;
        String string = null;
        String string2 = null;
        long l = -1L;
        if (byteBlock != null && byteBlock.getLength() >= 2) {
            n = BinaryTools.getUShort(byteBlock, 0);
            if (byteBlock.getLength() > 10) {
                byteBlock2 = ByteBlock.wrap(byteBlock.subBlock(2, 16).toByteArray());
                if (byteBlock.getLength() >= 22) {
                    int n2 = BinaryTools.getUShort(byteBlock, 18);
                    int n3 = BinaryTools.getUShort(byteBlock, 20);
                    if (byteBlock.getLength() >= 22 + n2 + n3) {
                        StringBlock stringBlock = BinaryTools.getNullPadded(byteBlock.subBlock(22));
                        string = stringBlock.getString();
                        StringBlock stringBlock2 = BinaryTools.getNullPadded(byteBlock.subBlock(22 + stringBlock.getTotalSize() + 1));
                        string2 = stringBlock2.getString();
                        l = BinaryTools.getUInt(byteBlock, 22 + stringBlock.getTotalSize() + 1 + stringBlock2.getTotalSize() + 1);
                    }
                }
            }
        }
        this.code = n;
        this.uuid = byteBlock2;
        this.addinName = string;
        this.computerName = string2;
        this.flags = l;
        this.invMessage = InvitationMessage.readInvitationMessage(tlvChain);
    }

    public AddinsReqRvCmd(int n, String string, ByteBlock byteBlock, String string2, String string3, long l, InvitationMessage invitationMessage) {
        super(CapabilityBlock.BLOCK_ADDINS);
        DefensiveTools.checkRange(n, "code", -1);
        DefensiveTools.checkRange(l, "flags", -1L);
        if (byteBlock != null && byteBlock.getLength() != 16) {
            throw new IllegalArgumentException("uuid length (" + byteBlock.getLength() + ") must be 16 if uuid is non-null");
        }
        this.code = n;
        this.addinUri = string;
        this.uuid = byteBlock;
        this.addinName = string2;
        this.computerName = string3;
        this.flags = l;
        this.invMessage = invitationMessage;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getAddinUri() {
        return this.addinUri;
    }

    public final ByteBlock getAddinUuid() {
        return this.uuid;
    }

    public final String getAddinName() {
        return this.addinName;
    }

    public final String getComputerName() {
        return this.computerName;
    }

    public final long getFlags() {
        return this.flags;
    }

    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
        if (this.addinUri != null) {
            Tlv.getStringInstance(7, this.addinUri).write(outputStream);
        }
        if (this.invMessage != null) {
            this.invMessage.write(outputStream);
        }
    }

    protected boolean hasServiceData() {
        return true;
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
        if (this.code != -1) {
            BinaryTools.writeUShort(outputStream, this.code);
            if (this.uuid != null) {
                this.uuid.write(outputStream);
                if (this.addinName != null && this.computerName != null) {
                    byte[] byArray = BinaryTools.getAsciiBytes(this.addinName);
                    byte[] byArray2 = BinaryTools.getAsciiBytes(this.computerName);
                    BinaryTools.writeUShort(outputStream, byArray.length);
                    BinaryTools.writeUShort(outputStream, byArray2.length);
                    outputStream.write(byArray);
                    outputStream.write(0);
                    outputStream.write(byArray2);
                    outputStream.write(0);
                    if (this.flags != -1L) {
                        BinaryTools.writeUInt(outputStream, this.flags);
                    }
                }
            }
        }
    }

    public String toString() {
        return "AddinsReqRvCmd: code=" + this.code + ", addinName=" + this.addinName + ", computerName=" + this.computerName + ", flags=0x" + Long.toHexString(this.flags) + ", message=<" + this.invMessage + ">, uri=" + this.addinUri;
    }
}

