/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.FileSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Checksum
extends MatchingTask
implements Condition {
    private File file;
    private File todir;
    private String algorithm;
    private String provider;
    private String fileext;
    private String property;
    private Map allDigests;
    private Map relativeFilePaths;
    private String totalproperty;
    private boolean forceOverwrite;
    private String verifyProperty;
    private Vector filesets;
    private Hashtable includeFileMap;
    private MessageDigest messageDigest;
    private boolean isCondition;
    private int readBufferSize;

    public void setFile(File file) {
        this.file = file;
    }

    public void setTodir(File file) {
        this.todir = file;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public void setFileext(String string) {
        this.fileext = string;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setTotalproperty(String string) {
        this.totalproperty = string;
    }

    public void setVerifyproperty(String string) {
        this.verifyProperty = string;
    }

    public void setForceOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    public void setReadBufferSize(int n) {
        this.readBufferSize = n;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        this.isCondition = false;
        boolean bl = this.validateAndExecute();
        if (this.verifyProperty != null) {
            this.getProject().setNewProperty(this.verifyProperty, new Boolean(bl).toString());
        }
    }

    public boolean eval() throws BuildException {
        this.isCondition = true;
        return this.validateAndExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validateAndExecute() throws BuildException {
        String string = this.fileext;
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Checksum cannot be generated for directories");
        }
        if (this.file != null && this.totalproperty != null) {
            throw new BuildException("File and Totalproperty cannot co-exist.");
        }
        if (this.property != null && this.fileext != null) {
            throw new BuildException("Property and FileExt cannot co-exist.");
        }
        if (this.property != null) {
            if (this.forceOverwrite) {
                throw new BuildException("ForceOverwrite cannot be used when Property is specified");
            }
            if (this.file != null ? this.filesets.size() > 0 : this.filesets.size() > 1) {
                throw new BuildException("Multiple files cannot be used when Property is specified");
            }
        }
        if (this.verifyProperty != null) {
            this.isCondition = true;
        }
        if (this.verifyProperty != null && this.forceOverwrite) {
            throw new BuildException("VerifyProperty and ForceOverwrite cannot co-exist.");
        }
        if (this.isCondition && this.forceOverwrite) {
            throw new BuildException("ForceOverwrite cannot be used when conditions are being used.");
        }
        this.messageDigest = null;
        if (this.provider != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new BuildException(noSuchAlgorithmException, this.getLocation());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new BuildException(noSuchProviderException, this.getLocation());
            }
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new BuildException(noSuchAlgorithmException, this.getLocation());
        }
        if (this.messageDigest == null) {
            throw new BuildException("Unable to create Message Digest", this.getLocation());
        }
        if (this.fileext == null) {
            this.fileext = "." + this.algorithm;
        } else if (this.fileext.trim().length() == 0) {
            throw new BuildException("File extension when specified must not be an empty string");
        }
        try {
            int n = this.filesets.size();
            int n2 = 0;
            while (n2 < n) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(n2);
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    File file = new File(fileSet.getDir(this.getProject()), stringArray[n3]);
                    if (this.totalproperty != null || this.todir != null) {
                        String string2 = stringArray[n3].replace(File.separatorChar, '/');
                        this.relativeFilePaths.put(file, string2);
                    }
                    this.addToIncludeFileMap(file);
                    ++n3;
                }
                ++n2;
            }
            this.addToIncludeFileMap(this.file);
            boolean bl = this.generateChecksums();
            Object var3_15 = null;
            this.fileext = string;
            this.includeFileMap.clear();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_16 = null;
            this.fileext = string;
            this.includeFileMap.clear();
            throw throwable;
        }
    }

    private final void addToIncludeFileMap(File file) throws BuildException {
        if (file != null) {
            if (file.exists()) {
                if (this.property == null) {
                    File file2 = this.getChecksumFile(file);
                    if (this.forceOverwrite || this.isCondition || file.lastModified() > file2.lastModified()) {
                        this.includeFileMap.put(file, file2);
                    } else {
                        this.log(file + " omitted as " + file2 + " is up to date.", 3);
                        if (this.totalproperty != null) {
                            Object object;
                            String string = null;
                            try {
                                object = new BufferedReader(new FileReader(file2));
                                string = ((BufferedReader)object).readLine();
                            }
                            catch (IOException iOException) {
                                throw new BuildException("Couldn't read checksum file " + file2, iOException);
                            }
                            object = Checksum.decodeHex(string.toCharArray());
                            this.allDigests.put(file, object);
                        }
                    }
                } else {
                    this.includeFileMap.put(file, this.property);
                }
            } else {
                String string = "Could not find file " + file.getAbsolutePath() + " to generate checksum for.";
                this.log(string);
                throw new BuildException(string, this.getLocation());
            }
        }
    }

    private final File getChecksumFile(File file) {
        File file2;
        Object object;
        if (this.todir != null) {
            object = (String)this.relativeFilePaths.get(file);
            file2 = new File(this.todir, (String)object).getParentFile();
            file2.mkdirs();
        } else {
            file2 = file.getParentFile();
        }
        object = new File(file2, file.getName() + this.fileext);
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean generateChecksums() throws BuildException {
        block25: {
            var1_1 = true;
            var2_2 = null;
            var3_3 = null;
            var4_4 = new byte[this.readBufferSize];
            try {
                try {
                    var9_5 = this.includeFileMap.keys();
                    while (true) {
                        block26: {
                            if (var9_5.hasMoreElements()) break block26;
                            if (this.totalproperty != null) {
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        this.messageDigest.reset();
                        var10_7 = (Object[])var9_5.nextElement();
                        if (!this.isCondition) {
                            this.log("Calculating " + this.algorithm + " checksum for " + var10_7, 3);
                        }
                        var2_2 = new FileInputStream((File)var10_7);
                        var11_8 = new DigestInputStream(var2_2, this.messageDigest);
                        while (var11_8.read(var4_4, 0, this.readBufferSize) != -1) {
                        }
                        var11_8.close();
                        var2_2.close();
                        var2_2 = null;
                        var12_11 = this.messageDigest.digest();
                        if (this.totalproperty != null) {
                            this.allDigests.put(var10_7, var12_11);
                        }
                        var13_12 = this.createDigestString((byte[])var12_11);
                        var14_13 /* !! */  = this.includeFileMap.get(var10_7);
                        if (var14_13 /* !! */  instanceof String) {
                            var15_14 = var14_13 /* !! */ ;
                            if (this.isCondition) {
                                v0 = false;
                                if (var1_1 && var13_12.equals(this.property)) {
                                    v0 = true;
                                }
                                var1_1 = v0;
                                continue;
                            }
                            this.getProject().setNewProperty((String)var15_14, (String)var13_12);
                            continue;
                        }
                        if (!(var14_13 /* !! */  instanceof File)) continue;
                        if (this.isCondition) {
                            var15_14 = (File)var14_13 /* !! */ ;
                            if (var15_14.exists()) {
                                var2_2 = new FileInputStream((File)var15_14);
                                var16_15 = new InputStreamReader(var2_2);
                                var17_16 = new BufferedReader(var16_15);
                                var18_17 = var17_16.readLine();
                                var2_2.close();
                                var2_2 = null;
                                var17_16.close();
                                var16_15.close();
                                v1 = false;
                                if (var1_1 && var13_12.equals(var18_17)) {
                                    v1 = true;
                                }
                                var1_1 = v1;
                                continue;
                            }
                            var1_1 = false;
                            continue;
                        }
                        var15_14 = (File)var14_13 /* !! */ ;
                        var3_3 = new FileOutputStream((File)var15_14);
                        var3_3.write(var13_12.getBytes());
                        var3_3.close();
                        var3_3 = null;
                    }
                    var9_5 = this.allDigests.keySet();
                    var10_7 = var9_5.toArray();
                    Arrays.sort(var10_7);
                    this.messageDigest.reset();
                    var11_9 = 0;
                    while (true) {
                        block27: {
                            if (var11_9 < var10_7.length) break block27;
                            var11_10 = this.createDigestString(this.messageDigest.digest());
                            this.getProject().setNewProperty(this.totalproperty, var11_10);
                            break;
                        }
                        var12_11 = (File)var10_7[var11_9];
                        var13_12 = (byte[])this.allDigests.get(var12_11);
                        this.messageDigest.update((byte[])var13_12);
                        var14_13 /* !! */  = (String)this.relativeFilePaths.get(var12_11);
                        this.messageDigest.update(var14_13 /* !! */ .getBytes());
                        ++var11_9;
                    }
                }
                catch (Exception var9_6) {
                    throw new BuildException(var9_6, this.getLocation());
                }
            }
            catch (Throwable var5_18) {
                var6_19 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException v2) {}
                }
                if (var3_3 == null) throw var5_18;
                try {
                    var3_3.close();
                    throw var5_18;
                }
                catch (IOException v3) {}
                throw var5_18;
            }
lbl-1000:
            // 2 sources

            {
                var6_20 = null;
                if (var2_2 == null) break block25;
            }
            try {}
            catch (IOException v4) {}
            var2_2.close();
        }
        if (var3_3 == null) return var1_1;
        try {}
        catch (IOException v5) {
            return var1_1;
        }
        var3_3.close();
        return var1_1;
    }

    private final String createDigestString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            String string = Integer.toHexString(0xFF & byArray[n]);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] decodeHex(char[] cArray) throws BuildException {
        int n = cArray.length;
        if ((n & 1) != 0) {
            throw new BuildException("odd number of characters.");
        }
        byte[] byArray = new byte[n >> 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = Character.digit(cArray[n3++], 16) << 4;
            byArray[n2] = (byte)((n4 |= Character.digit(cArray[n3++], 16)) & 0xFF);
            ++n2;
        }
        return byArray;
    }

    private final /* synthetic */ void this() {
        this.file = null;
        this.algorithm = "MD5";
        this.provider = null;
        this.allDigests = new HashMap();
        this.relativeFilePaths = new HashMap();
        this.filesets = new Vector();
        this.includeFileMap = new Hashtable();
        this.readBufferSize = 8192;
    }

    public Checksum() {
        this.this();
    }
}

