/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.GracefulShutdownIQ;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jitsi.service.version.Version;
import org.jitsi.service.version.VersionService;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.rest.Health;
import org.jitsi.videobridge.rest.JSONDeserializer;
import org.jitsi.videobridge.rest.JSONSerializer;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsManager;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;

class HandlerImpl
extends AbstractHandler {
    private static final String CONFERENCES = "conferences";
    private static final String DEFAULT_COLIBRI_TARGET = "/colibri/";
    private static final String DEFAULT_JSON_TARGET = null;
    private static final String DOMINANT_SPEAKER_IDENTIFICATION = "dominant-speaker-identification";
    private static final String GET_HTTP_METHOD = "GET";
    private static final String HEALTH_TARGET = "/health";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String JSON_CONTENT_TYPE_WITH_CHARSET = "application/json;charset=UTF-8";
    private static final Logger logger = Logger.getLogger(HandlerImpl.class);
    private static final String PATCH_HTTP_METHOD = "PATCH";
    private static final String POST_HTTP_METHOD = "POST";
    private static final String SHUTDOWN = "shutdown";
    private static final String STATISTICS = "stats";
    private static final String VERSION_TARGET = "/version";
    private final BundleContext bundleContext;
    private String colibriTarget;
    private String jsonTarget;
    private final boolean shutdownEnabled;

    private static int getHttpStatusCodeForResultIq(IQ responseIQ) {
        String condition = responseIQ.getError().getCondition();
        if (XMPPError.Condition.not_authorized.toString().equals(condition)) {
            return 401;
        }
        if (XMPPError.Condition.service_unavailable.toString().equals(condition)) {
            return 503;
        }
        return 500;
    }

    public HandlerImpl(BundleContext bundleContext, boolean enableShutdown) {
        this.bundleContext = bundleContext;
        this.colibriTarget = DEFAULT_COLIBRI_TARGET;
        if (!this.colibriTarget.endsWith("/")) {
            this.colibriTarget = this.colibriTarget + "/";
        }
        this.jsonTarget = DEFAULT_JSON_TARGET;
        if (this.jsonTarget != null && !this.jsonTarget.startsWith(".")) {
            this.jsonTarget = "." + this.jsonTarget;
        }
        this.shutdownEnabled = enableShutdown;
    }

    private void beginResponse(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response, String contentType) {
        response.setContentType(contentType);
        response.setHeader("Access-Control-Allow-Origin", "*");
    }

    private void doGetConferenceJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else {
            Conference conference;
            int conferenceIDEndIndex = target.indexOf(47);
            String conferenceID = target;
            if (conferenceIDEndIndex > 0 && conferenceIDEndIndex < target.length() - 1 && DOMINANT_SPEAKER_IDENTIFICATION.equals(target = target.substring(conferenceIDEndIndex + 1))) {
                conferenceID = conferenceID.substring(0, conferenceIDEndIndex);
            }
            if ((conference = videobridge.getConference(conferenceID, null)) == null) {
                response.setStatus(404);
            } else if (DOMINANT_SPEAKER_IDENTIFICATION.equals(target)) {
                this.doGetDominantSpeakerIdentificationJSON(conference, baseRequest, request, response);
            } else {
                ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                conference.describeDeep(conferenceIQ);
                JSONObject conferenceJSONObject = JSONSerializer.serializeConference(conferenceIQ);
                if (conferenceJSONObject == null) {
                    response.setStatus(500);
                } else {
                    response.setStatus(200);
                    conferenceJSONObject.writeJSONString((Writer)response.getWriter());
                }
            }
        }
    }

    private void doGetConferencesJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else {
            Conference[] conferences = videobridge.getConferences();
            ArrayList<ColibriConferenceIQ> conferenceIQs = new ArrayList<ColibriConferenceIQ>();
            for (Conference conference : conferences) {
                ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                conferenceIQ.setID(conference.getID());
                conferenceIQs.add(conferenceIQ);
            }
            JSONArray conferencesJSONArray = JSONSerializer.serializeConferences(conferenceIQs);
            if (conferencesJSONArray == null) {
                conferencesJSONArray = new JSONArray();
            }
            response.setStatus(200);
            conferencesJSONArray.writeJSONString((Writer)response.getWriter());
        }
    }

    private void doGetDominantSpeakerIdentificationJSON(Conference conference, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConferenceSpeechActivity conferenceSpeechActivity = conference.getSpeechActivity();
        if (conferenceSpeechActivity == null) {
            response.setStatus(503);
        } else {
            JSONObject jsonObject = conferenceSpeechActivity.doGetDominantSpeakerIdentificationJSON();
            if (jsonObject != null) {
                response.setStatus(200);
                jsonObject.writeJSONString((Writer)response.getWriter());
            }
        }
    }

    private void doGetHealthJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else {
            Health.getJSON(videobridge, baseRequest, request, response);
        }
    }

    private void doGetStatisticsJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StatsManager statsManager;
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null && (statsManager = (StatsManager)ServiceUtils.getService((BundleContext)bundleContext, StatsManager.class)) != null) {
            Iterator<Statistics> i = statsManager.getStatistics().iterator();
            Statistics statistics = null;
            if (i.hasNext()) {
                statistics = i.next();
            }
            JSONObject statisticsJSONObject = JSONSerializer.serializeStatistics(statistics);
            PrintWriter writer = response.getWriter();
            response.setStatus(200);
            if (statisticsJSONObject == null) {
                ((Writer)writer).write("null");
            } else {
                statisticsJSONObject.writeJSONString((Writer)writer);
            }
            return;
        }
        response.setStatus(503);
    }

    private void doGetVersionJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VersionService versionService;
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null && (versionService = (VersionService)ServiceUtils.getService((BundleContext)bundleContext, VersionService.class)) != null) {
            Version version = versionService.getCurrentVersion();
            JSONObject versionJSONObject = new JSONObject();
            versionJSONObject.put((Object)"name", (Object)version.getApplicationName());
            versionJSONObject.put((Object)"version", (Object)version.toString());
            versionJSONObject.put((Object)"os", (Object)System.getProperty("os.name"));
            PrintWriter writer = response.getWriter();
            response.setStatus(200);
            versionJSONObject.writeJSONString((Writer)writer);
            return;
        }
        response.setStatus(503);
    }

    private void doPatchConferenceJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else {
            Conference conference = videobridge.getConference(target, null);
            if (conference == null) {
                response.setStatus(404);
            } else if (this.isJSONContentType(request.getContentType())) {
                Object requestJSONObject = null;
                int status = 0;
                try {
                    requestJSONObject = new JSONParser().parse((Reader)request.getReader());
                    if (requestJSONObject == null || !(requestJSONObject instanceof JSONObject)) {
                        status = 400;
                    }
                }
                catch (ParseException pe) {
                    status = 400;
                }
                if (status == 0) {
                    ColibriConferenceIQ requestConferenceIQ = JSONDeserializer.deserializeConference((JSONObject)requestJSONObject);
                    if (requestConferenceIQ == null || requestConferenceIQ.getID() != null && !requestConferenceIQ.getID().equals(conference.getID())) {
                        status = 400;
                    } else {
                        ColibriConferenceIQ responseConferenceIQ = null;
                        try {
                            IQ responseIQ = videobridge.handleColibriConferenceIQ(requestConferenceIQ, 1);
                            if (responseIQ instanceof ColibriConferenceIQ) {
                                responseConferenceIQ = (ColibriConferenceIQ)responseIQ;
                            } else {
                                status = HandlerImpl.getHttpStatusCodeForResultIq(responseIQ);
                            }
                        }
                        catch (Exception e) {
                            status = 500;
                        }
                        if (status == 0 && responseConferenceIQ != null) {
                            JSONObject responseJSONObject = JSONSerializer.serializeConference(responseConferenceIQ);
                            if (responseJSONObject == null) {
                                responseJSONObject = new JSONObject();
                            }
                            response.setStatus(200);
                            responseJSONObject.writeJSONString((Writer)response.getWriter());
                        }
                    }
                }
                if (status != 0) {
                    response.setStatus(status);
                }
            } else {
                response.setStatus(406);
            }
        }
    }

    private void doPostConferencesJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
        } else if (this.isJSONContentType(request.getContentType())) {
            Object requestJSONObject = null;
            int status = 0;
            try {
                requestJSONObject = new JSONParser().parse((Reader)request.getReader());
                if (requestJSONObject == null || !(requestJSONObject instanceof JSONObject)) {
                    status = 400;
                }
            }
            catch (ParseException pe) {
                status = 400;
            }
            if (status == 0) {
                ColibriConferenceIQ requestConferenceIQ = JSONDeserializer.deserializeConference((JSONObject)requestJSONObject);
                if (requestConferenceIQ == null || requestConferenceIQ.getID() != null) {
                    status = 400;
                } else {
                    ColibriConferenceIQ responseConferenceIQ = null;
                    try {
                        IQ responseIQ = videobridge.handleColibriConferenceIQ(requestConferenceIQ, 1);
                        if (responseIQ instanceof ColibriConferenceIQ) {
                            responseConferenceIQ = (ColibriConferenceIQ)responseIQ;
                        } else {
                            status = HandlerImpl.getHttpStatusCodeForResultIq(responseIQ);
                        }
                    }
                    catch (Exception e) {
                        status = 500;
                    }
                    if (status == 0 && responseConferenceIQ != null) {
                        JSONObject responseJSONObject = JSONSerializer.serializeConference(responseConferenceIQ);
                        if (responseJSONObject == null) {
                            responseJSONObject = new JSONObject();
                        }
                        response.setStatus(200);
                        responseJSONObject.writeJSONString((Writer)response.getWriter());
                    }
                }
            }
            if (status != 0) {
                response.setStatus(status);
            }
        } else {
            response.setStatus(406);
        }
    }

    private void doPostShutdownJSON(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int status;
        Object requestJSONObject;
        Videobridge videobridge = this.getVideobridge();
        if (videobridge == null) {
            response.setStatus(503);
            return;
        }
        if (!this.isJSONContentType(request.getContentType())) {
            response.setStatus(406);
            return;
        }
        try {
            requestJSONObject = new JSONParser().parse((Reader)request.getReader());
            if (requestJSONObject == null || !(requestJSONObject instanceof JSONObject)) {
                response.setStatus(400);
                return;
            }
        }
        catch (ParseException pe) {
            response.setStatus(400);
            return;
        }
        GracefulShutdownIQ requestShutdownIQ = JSONDeserializer.deserializeShutdownIQ((JSONObject)requestJSONObject);
        if (requestShutdownIQ == null) {
            status = 400;
        } else {
            String ipAddress = request.getHeader("X-FORWARDED-FOR");
            if (ipAddress == null) {
                ipAddress = request.getRemoteAddr();
            }
            requestShutdownIQ.setFrom(ipAddress);
            IQ responseIQ = null;
            try {
                responseIQ = videobridge.handleGracefulShutdownIQ(requestShutdownIQ);
                status = IQ.Type.RESULT.equals(responseIQ.getType()) ? 200 : HandlerImpl.getHttpStatusCodeForResultIq(responseIQ);
            }
            catch (Exception e) {
                logger.error((Object)"Error while trying to handle shutdown request", (Throwable)e);
                status = 500;
            }
        }
        response.setStatus(status);
    }

    private void endResponse(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
        if (!baseRequest.isHandled()) {
            if (response.getStatus() == 0) {
                response.setStatus(404);
            }
            baseRequest.setHandled(true);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Videobridge getVideobridge() {
        BundleContext bundleContext = this.getBundleContext();
        Videobridge videobridge = bundleContext == null ? null : (Videobridge)ServiceUtils.getService((BundleContext)bundleContext, Videobridge.class);
        return videobridge;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target != null) {
            int jsonTargetLength;
            int n = jsonTargetLength = this.jsonTarget == null ? 0 : this.jsonTarget.length();
            if (jsonTargetLength == 0 || target.endsWith(this.jsonTarget)) {
                if ((target = target.substring(0, target.length() - jsonTargetLength)).startsWith(this.colibriTarget)) {
                    target = target.substring(this.colibriTarget.length());
                    this.beginResponse(target, baseRequest, request, response, JSON_CONTENT_TYPE_WITH_CHARSET);
                    this.handleColibriJSON(target, baseRequest, request, response);
                    this.endResponse(target, baseRequest, request, response);
                } else if (HEALTH_TARGET.equals(target)) {
                    target = target.substring(HEALTH_TARGET.length());
                    this.beginResponse(target, baseRequest, request, response, JSON_CONTENT_TYPE_WITH_CHARSET);
                    this.handleHealthJSON(target, baseRequest, request, response);
                    this.endResponse(target, baseRequest, request, response);
                } else if (VERSION_TARGET.equals(target)) {
                    target = target.substring(VERSION_TARGET.length());
                    this.beginResponse(target, baseRequest, request, response, JSON_CONTENT_TYPE_WITH_CHARSET);
                    this.handleVersionJSON(target, baseRequest, request, response);
                    this.endResponse(target, baseRequest, request, response);
                }
            }
        }
    }

    private void handleColibriJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target != null) {
            if (target.startsWith(CONFERENCES)) {
                if ((target = target.substring(CONFERENCES.length())).startsWith("/")) {
                    target = target.substring(1);
                }
                String requestMethod = request.getMethod();
                if ("".equals(target)) {
                    if (GET_HTTP_METHOD.equals(requestMethod)) {
                        this.doGetConferencesJSON(baseRequest, request, response);
                    } else if (POST_HTTP_METHOD.equals(requestMethod)) {
                        this.doPostConferencesJSON(baseRequest, request, response);
                    } else {
                        response.setStatus(405);
                    }
                } else if (GET_HTTP_METHOD.equals(requestMethod)) {
                    this.doGetConferenceJSON(target, baseRequest, request, response);
                } else if (PATCH_HTTP_METHOD.equals(requestMethod)) {
                    this.doPatchConferenceJSON(target, baseRequest, request, response);
                } else {
                    response.setStatus(405);
                }
            } else if (target.equals(STATISTICS)) {
                if (GET_HTTP_METHOD.equals(request.getMethod())) {
                    this.doGetStatisticsJSON(baseRequest, request, response);
                } else {
                    response.setStatus(405);
                }
            } else if (target.equals(SHUTDOWN)) {
                if (!this.shutdownEnabled) {
                    response.setStatus(503);
                    return;
                }
                if (POST_HTTP_METHOD.equals(request.getMethod())) {
                    this.doPostShutdownJSON(baseRequest, request, response);
                } else {
                    response.setStatus(405);
                }
            }
        }
    }

    private void handleHealthJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (GET_HTTP_METHOD.equals(request.getMethod())) {
            this.doGetHealthJSON(baseRequest, request, response);
        } else {
            response.setStatus(405);
        }
    }

    private void handleVersionJSON(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (GET_HTTP_METHOD.equals(request.getMethod())) {
            this.doGetVersionJSON(baseRequest, request, response);
        } else {
            response.setStatus(405);
        }
    }

    private boolean isJSONContentType(String contentType) {
        return JSON_CONTENT_TYPE.equals(contentType) || JSON_CONTENT_TYPE_WITH_CHARSET.equals(contentType);
    }
}

