/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCache;
import org.jitsi.service.neomedia.Transformer;

public class FeedbackCacheUpdater
implements Transformer<RTCPCompoundPacket> {
    private static RTCPReportBlock[] NO_RTCP_REPORT_BLOCKS = new RTCPReportBlock[0];
    private FeedbackCache feedbackCache;

    public FeedbackCacheUpdater(FeedbackCache feedbackCache) {
        this.feedbackCache = feedbackCache;
    }

    @Override
    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        if (inPacket == null || inPacket.packets == null || inPacket.packets.length == 0) {
            return inPacket;
        }
        RTCPReportBlock[] reports = null;
        RTCPREMBPacket remb = null;
        int ssrc = 0;
        block8: for (RTCPPacket p : inPacket.packets) {
            switch (p.type) {
                case 201: {
                    RTCPRRPacket rr = (RTCPRRPacket)p;
                    reports = rr.reports;
                    ssrc = rr.ssrc;
                    continue block8;
                }
                case 200: {
                    RTCPSRPacket sr = (RTCPSRPacket)p;
                    reports = sr.reports;
                    ssrc = sr.ssrc;
                    sr.reports = NO_RTCP_REPORT_BLOCKS;
                    continue block8;
                }
                case 206: {
                    RTCPFBPacket psfb = (RTCPFBPacket)p;
                    switch (psfb.fmt) {
                        case 15: {
                            remb = (RTCPREMBPacket)p;
                            ssrc = (int)remb.senderSSRC;
                        }
                    }
                    continue block8;
                }
            }
        }
        this.feedbackCache.update(ssrc, reports, remb);
        return inPacket;
    }

    @Override
    public void close() {
    }

    @Override
    public RTCPCompoundPacket transform(RTCPCompoundPacket inPacket) {
        return inPacket;
    }
}

