/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import org.jitsi.util.JNIUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.StringUtils;

public class CoreAudioDevice {
    private static final Logger logger = Logger.getLogger(CoreAudioDevice.class);
    public static boolean isLoaded;
    private static Runnable devicesChangedCallback;

    public static native void freeDevices();

    public static String getDeviceModelIdentifier(String deviceUID) {
        if (deviceUID == null) {
            throw new NullPointerException("deviceUID");
        }
        byte[] deviceModelIdentifierBytes = CoreAudioDevice.getDeviceModelIdentifierBytes(deviceUID);
        String deviceModelIdentifier = StringUtils.newString(deviceModelIdentifierBytes);
        return deviceModelIdentifier;
    }

    public static native byte[] getDeviceModelIdentifierBytes(String var0);

    public static String getDeviceName(String deviceUID) {
        byte[] deviceNameBytes = CoreAudioDevice.getDeviceNameBytes(deviceUID);
        String deviceName = StringUtils.newString(deviceNameBytes);
        return deviceName;
    }

    public static native byte[] getDeviceNameBytes(String var0);

    public static native float getInputDeviceVolume(String var0);

    public static native float getOutputDeviceVolume(String var0);

    public static native int initDevices();

    public static native int setInputDeviceVolume(String var0, float var1);

    public static native int setOutputDeviceVolume(String var0, float var1);

    public static void devicesChangedCallback() {
        Runnable devicesChangedCallback = CoreAudioDevice.devicesChangedCallback;
        if (devicesChangedCallback != null) {
            devicesChangedCallback.run();
        }
    }

    public static void setDevicesChangedCallback(Runnable devicesChangedCallback) {
        CoreAudioDevice.devicesChangedCallback = devicesChangedCallback;
    }

    public static void log(byte[] error) {
        String errorString = StringUtils.newString(error);
        logger.info(errorString);
    }

    static {
        boolean isLoaded = false;
        try {
            String libname = null;
            if (OSUtils.IS_MAC) {
                libname = "jnmaccoreaudio";
            } else if (OSUtils.IS_WINDOWS_VISTA || OSUtils.IS_WINDOWS_7 || OSUtils.IS_WINDOWS_8) {
                libname = "jnwincoreaudio";
            }
            if (libname != null) {
                JNIUtils.loadLibrary(libname, CoreAudioDevice.class.getClassLoader());
                isLoaded = true;
            }
        }
        catch (NullPointerException npe) {
            logger.info("Failed to load CoreAudioDevice library: ", npe);
        }
        catch (SecurityException se) {
            logger.info("Failed to load CoreAudioDevice library: ", se);
        }
        catch (UnsatisfiedLinkError ule) {
            logger.info("Failed to load CoreAudioDevice library: ", ule);
        }
        CoreAudioDevice.isLoaded = isLoaded;
    }
}

