/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import com.lti.utils.OSUtils;
import com.lti.utils.StringUtils;
import java.io.File;

public final class URLUtils {
    public static String createAbsoluteFileUrl(String string) {
        String string2 = URLUtils.extractValidPathFromFileUrl(string);
        if (string2 == null) {
            return null;
        }
        return URLUtils.createUrlStr(new File(string2));
    }

    public static String createUrlStr(File file) {
        String string = file.getAbsolutePath();
        String string2 = string.startsWith("/") ? "file://" : "file:///";
        if (OSUtils.isWindows()) {
            string = string.replaceAll("\\\\", "/");
        }
        return string2 + StringUtils.replaceSpecialUrlChars(string, true);
    }

    private static boolean exists(String string, boolean bl) {
        File file = new File(string);
        if (bl) {
            return file.getParentFile() == null || file.getParentFile().exists();
        }
        return file.exists();
    }

    public static String extractValidNewFilePathFromFileUrl(String string) {
        return URLUtils.extractValidPathFromFileUrl(string, true);
    }

    public static String extractValidPathFromFileUrl(String string) {
        return URLUtils.extractValidPathFromFileUrl(string, false);
    }

    private static String extractValidPathFromFileUrl(String string, boolean bl) {
        String string2;
        if (!string.startsWith("file:")) {
            return null;
        }
        String string3 = string.substring("file:".length());
        if (!(string3 = StringUtils.restoreSpecialURLChars(string3)).startsWith("/")) {
            return string3;
        }
        if (string3.startsWith("//") && URLUtils.exists(string2 = string3.substring(2), bl)) {
            return URLUtils.windowsSafe(string2);
        }
        string2 = string3;
        while (string2.startsWith("//")) {
            string2 = string2.substring(1);
        }
        if (URLUtils.exists(string2, bl)) {
            return URLUtils.windowsSafe(string2);
        }
        while (string2.startsWith("/")) {
            if (!URLUtils.exists(string2 = string2.substring(1), bl)) continue;
            return URLUtils.windowsSafe(string2);
        }
        return null;
    }

    private static String windowsSafe(String string) {
        if (OSUtils.isWindows() && string.startsWith("/")) {
            return string.substring(1);
        }
        return string;
    }

    private URLUtils() {
    }
}

