/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

public class RingBuffer {
    private Object[] buckets;
    private int readIndex;
    private int writeIndex;
    private int overrunCounter;

    public RingBuffer(int n) {
        this.resize(n);
    }

    public synchronized Object get() throws InterruptedException {
        if (this.isEmpty()) {
            this.wait();
        }
        Object object = this.buckets[this.readIndex++];
        if (this.readIndex >= this.buckets.length) {
            this.readIndex = 0;
        }
        return object;
    }

    public synchronized int getOverrunCounter() {
        return this.overrunCounter;
    }

    public synchronized boolean isEmpty() {
        return this.readIndex == this.writeIndex;
    }

    public synchronized boolean isFull() {
        int n = this.writeIndex + 1;
        if (n >= this.buckets.length) {
            n = 0;
        }
        return n == this.readIndex;
    }

    public synchronized Object peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.buckets[this.readIndex];
    }

    public synchronized boolean put(Object object) {
        boolean bl = false;
        if (this.isFull()) {
            try {
                this.get();
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.overrunCounter;
        }
        this.buckets[this.writeIndex++] = object;
        if (this.writeIndex >= this.buckets.length) {
            this.writeIndex = 0;
        }
        this.notifyAll();
        return bl;
    }

    public synchronized void resize(int n) {
        if (n < 1) {
            n = 1;
        }
        this.buckets = new Object[n + 1];
        this.overrunCounter = 0;
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public synchronized int size() {
        return this.buckets.length - 1;
    }
}

